/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.filter;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.filter.RejectedCountDto;
import cn.com.duibaboot.ext.autoconfigure.web.container.EmbeddedServletContainerThreadPoolHolder;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfTestFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PerfTestFilter.class);
    private LoadingCache<String, RejectedCountDto> servicePerfTestRejectedRequestCountCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).initialCapacity(1).maximumSize(1L).build(s -> new RejectedCountDto());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        PerfTestContext._setPerfTestMode((Boolean)false);
        boolean isPerfTestMode = PerfTestUtils.isPerfTestRequest((HttpServletRequest)((HttpServletRequest)request));
        if (isPerfTestMode) {
            PerfTestContext._setPerfTestMode((Boolean)true);
            if (this.isServerBusy()) {
                HttpServletResponse resp = (HttpServletResponse)response;
                resp.setStatus(429);
                resp.getWriter().write("server busy(_duibaPerf=true)");
                return;
            }
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            PerfTestContext._setPerfTestMode((Boolean)false);
        }
    }

    private boolean isServerBusy() {
        ThreadPoolExecutor es = EmbeddedServletContainerThreadPoolHolder.getServletContainerThreadPool();
        if (es == null) {
            log.warn("\u83b7\u53d6\u4e0d\u5230servlet\u5bb9\u5668\u7ebf\u7a0b\u6c60\uff0c\u65e0\u6cd5\u5224\u8bfb\u662f\u5426\u8981\u5bf9\u538b\u6d4b\u8bf7\u6c42\u8fdb\u884c\u62d2\u7edd\u6216\u7194\u65ad\uff0c\u8bf7\u786e\u8ba4");
            return false;
        }
        if (this.isCircuitBreak()) {
            return true;
        }
        if (es.getQueue().size() > 5) {
            this.addRejectCount();
            return true;
        }
        int activeCount = es.getActiveCount();
        int coreSize = es.getCorePoolSize();
        int poolSize = es.getPoolSize();
        if (EmbeddedServletContainerThreadPoolHolder.getServletContainerType() == EmbeddedServletContainerThreadPoolHolder.ServletContainerType.TOMCAT) {
            poolSize = es.getMaximumPoolSize();
        }
        if ((double)activeCount * 1.0 / (double)(poolSize = Math.max(coreSize, poolSize)) >= 0.8) {
            this.addRejectCount();
            return true;
        }
        return false;
    }

    private boolean isCircuitBreak() {
        RejectedCountDto rejectedCountDto = (RejectedCountDto)this.servicePerfTestRejectedRequestCountCache.get((Object)"");
        if (rejectedCountDto.isCircuitBreak()) {
            if (!rejectedCountDto.isLogged) {
                rejectedCountDto.isLogged = true;
                log.warn("\u538b\u6d4b\u65f6\u53d1\u73b0servlet\u5bb9\u5668\u7ebf\u7a0b\u6c60\u8fc7\u4e8e\u7e41\u5fd9\uff0c\u5df2\u7194\u65ad5\u79d2\u5185\u7684\u6240\u6709\u538b\u6d4b\u8bf7\u6c42");
            }
            return true;
        }
        return false;
    }

    private void addRejectCount() {
        RejectedCountDto rejectedCountDto = (RejectedCountDto)this.servicePerfTestRejectedRequestCountCache.get((Object)"");
        rejectedCountDto.incrRejectedCount();
    }

    public void destroy() {
    }
}

