/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.guava;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.springframework.util.Assert;

public class GuavaCacheInterceptor
implements InstanceMethodsAroundInterceptor {
    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Assert.state((boolean)"build".equals(method.getName()), (String)"method name must be 'build', will not be here");
        if (method.getParameterCount() == 0) {
            Cache cacheForNormal = (Cache)ret;
            Cache cacheForPerfTest = (Cache)((Callable)zuperCall).call();
            return new AutoRoutingLocalCache(cacheForNormal, cacheForPerfTest);
        }
        if (method.getParameterCount() == 1) {
            LoadingCache cacheForNormal = (LoadingCache)ret;
            LoadingCache cacheForPerfTest = (LoadingCache)((Callable)zuperCall).call();
            return new AutoRoutingLocalLoadingCache(cacheForNormal, cacheForPerfTest);
        }
        throw new IllegalStateException("will never be here");
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    static class AutoRoutingLocalLoadingCache<K, V>
    extends AutoRoutingLocalCache<K, V>
    implements LoadingCache<K, V> {
        private AutoRoutingLocalLoadingCache(LoadingCache<K, V> cacheForNormal, LoadingCache<K, V> cacheForPerfTest) {
            super((Cache)cacheForNormal, (Cache)cacheForPerfTest);
        }

        @Override
        protected LoadingCache<K, V> determineCache() {
            return (LoadingCache)super.determineCache();
        }

        public V get(K key) throws ExecutionException {
            return (V)this.determineCache().get(key);
        }

        public V getUnchecked(K key) {
            return (V)this.determineCache().getUnchecked(key);
        }

        public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
            return this.determineCache().getAll(keys);
        }

        public void refresh(K key) {
            this.determineCache().refresh(key);
        }

        public final V apply(K key) {
            return (V)this.determineCache().apply(key);
        }

        @Override
        Object writeReplace() {
            LoadingCache<K, V> cache = this.determineCache();
            try {
                Method method = cache.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(true);
                return method.invoke(cache, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class AutoRoutingLocalCache<K, V>
    implements Cache<K, V> {
        private Cache<K, V> cacheForNormal;
        private Cache<K, V> cacheForPerfTest;

        private AutoRoutingLocalCache(Cache<K, V> cacheForNormal, Cache<K, V> cacheForPerfTest) {
            this.cacheForNormal = cacheForNormal;
            this.cacheForPerfTest = cacheForPerfTest;
        }

        protected Cache<K, V> determineCache() {
            return PerfTestContext.isCurrentInPerfTestMode() ? this.cacheForPerfTest : this.cacheForNormal;
        }

        public V getIfPresent(Object key) {
            return (V)this.determineCache().getIfPresent(key);
        }

        public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
            Preconditions.checkNotNull(valueLoader);
            return (V)this.determineCache().get(key, valueLoader);
        }

        public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
            return this.determineCache().getAllPresent(keys);
        }

        public void put(K key, V value) {
            this.determineCache().put(key, value);
        }

        public void putAll(Map<? extends K, ? extends V> m) {
            this.determineCache().putAll(m);
        }

        public void invalidate(Object key) {
            Preconditions.checkNotNull((Object)key);
            this.determineCache().invalidate(key);
        }

        public void invalidateAll(Iterable<?> keys) {
            this.determineCache().invalidateAll(keys);
        }

        public void invalidateAll() {
            this.determineCache().invalidateAll();
        }

        public long size() {
            return this.determineCache().size();
        }

        public ConcurrentMap<K, V> asMap() {
            return this.determineCache().asMap();
        }

        public CacheStats stats() {
            return this.determineCache().stats();
        }

        public void cleanUp() {
            this.determineCache().cleanUp();
        }

        Object writeReplace() {
            Cache<K, V> cache = this.determineCache();
            try {
                Method method = cache.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(true);
                return method.invoke(cache, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

