/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.threadpool.ThreadPoolBeanFactoryPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.threadpool.TransmittableExecutorBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.DuibaThreadPoolConfig;
import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ScheduledThreadPoolProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ScheduledThreadPoolExecutorWrapper;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
@Import(value={ThreadPoolBeanFactoryPostProcessor.class})
@EnableConfigurationProperties(value={DuibaThreadPoolConfig.class})
public class ThreadPoolAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(ThreadPoolAutoConfiguration.class);
    @Autowired
    private DuibaThreadPoolConfig duibaThreadPoolConfig;

    @Bean(name={"scheduledExecutorService"}, destroyMethod="shutdown")
    @ConditionalOnProperty(name={"duiba.threadpool.scheduled.enabled"}, havingValue="true", matchIfMissing=false)
    public ScheduledExecutorService scheduledExecutorService() {
        ScheduledThreadPoolProperties poolProperties = this.duibaThreadPoolConfig.getScheduled();
        return new ScheduledThreadPoolExecutorWrapper(poolProperties);
    }

    @Configuration
    public static class DuibaUncaughtExceptionHandlerConfiguarApplicationListener
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        private AtomicBoolean flag = new AtomicBoolean(true);

        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (!this.flag.compareAndSet(true, false)) {
                return;
            }
            if (Thread.getDefaultUncaughtExceptionHandler() == null) {
                Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
                    if (e instanceof ThreadDeath) {
                        // empty if block
                    }
                    logger.error("Thread[" + t.getId() + "," + t.getName() + "] caught error:", e);
                });
            }
        }

        public int getOrder() {
            return -15;
        }
    }

    @Configuration
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    public static class TransmittableThreadLocalConfigurer {
        @Bean
        public static SpecifiedBeanPostProcessor _executorServiceBeanPostProcessor() {
            return new TransmittableExecutorBeanPostProcessor();
        }
    }
}

