/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.accesslog;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duiba.wolf.utils.SecurityUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class AccessLogFilter
implements Filter {
    public static final ThreadLocal<Long> AppId = new ThreadLocal();
    public static final ThreadLocal<Long> ConsumerId = new ThreadLocal();
    public static final ThreadLocal<Map<String, String>> LogCookie = new ThreadLocal();
    public static final ThreadLocal<Map<String, Object>> EX = new ThreadLocal();
    public static final ThreadLocal<Map<String, String>> OverWrite = new ThreadLocal();
    public static final String OW_HOST = "host";
    public static final String ModeBlack = "black";
    public static final String ModeWhite = "white";
    private String mode = "black";
    private Set<String> inhosts = new HashSet<String>();
    private Set<String> blackPaths = new HashSet<String>();
    private Set<String> blackUriPatterns = new HashSet<String>();
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    private static final Logger accessLog = LoggerFactory.getLogger((String)"duiba_access_log");
    private static final Logger log = LoggerFactory.getLogger(AccessLogFilter.class);
    private Map<String, String> cookieHosts = new ConcurrentHashMap<String, String>();

    protected void loadConfig(Properties properties) {
        List<String> hosts;
        this.mode = properties.getProperty("accesslog.mode");
        String hoststring = properties.getProperty("accesslog.hosts");
        if (hoststring != null && !CollectionUtils.isEmpty(hosts = Arrays.asList(hoststring.trim().split(",")))) {
            this.inhosts = new HashSet<String>(hosts);
        }
        String blackpaths = properties.getProperty("accesslog.blackpaths");
        List<String> paths = Arrays.asList(StringUtils.split((String)StringUtils.trimToEmpty((String)blackpaths), (String)","));
        for (String path : paths) {
            if (path != null && !path.contains("*")) {
                this.blackPaths.add(path);
                continue;
            }
            if (path == null || !path.contains("*")) continue;
            this.blackUriPatterns.add(path);
        }
    }

    private String getHost(HttpServletRequest req) {
        String host;
        if (OverWrite.get() != null && (host = OverWrite.get().get(OW_HOST)) != null) {
            return host;
        }
        return req.getHeader(OW_HOST);
    }

    private boolean needLog(HttpServletRequest req) {
        String host = this.getHost(req);
        if (ModeBlack.equals(this.mode) ? this.inhosts.contains(host) : ModeWhite.equals(this.mode) && !this.inhosts.contains(host)) {
            return false;
        }
        String path = this.clearRequestURI(req.getRequestURI());
        if (this.blackPaths.contains(path)) {
            return false;
        }
        for (String pattern : this.blackUriPatterns) {
            if (!this.pathMatcher.match(pattern, path)) continue;
            return false;
        }
        return true;
    }

    public static void putLogCookie(String key, String value) {
        Map<String, String> map = LogCookie.get();
        if (map == null) {
            map = new HashMap<String, String>();
            LogCookie.set(map);
        }
        map.put(key, value);
    }

    public static void putExPair(String key, Object value) {
        Map<String, Object> ex = EX.get();
        if (ex == null) {
            ex = new HashMap<String, Object>();
            EX.set(ex);
        }
        ex.put(key, value);
    }

    public static void putOverWritePair(String key, String value) {
        Map<String, String> map = OverWrite.get();
        if (map == null) {
            map = new HashMap<String, String>();
            OverWrite.set(map);
        }
        map.put(key, value);
    }

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Long startTime = System.currentTimeMillis();
        HashMap<String, String> collCookie = new HashMap<String, String>();
        try {
            try {
                this.addCookieIfNeed((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, collCookie);
            }
            catch (Exception e) {
                log.error("addCookieIfNeed error");
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            try {
                HttpServletRequest req = (HttpServletRequest)servletRequest;
                boolean isPerfUrl = PerfTestUtils.isPerfTestRequest((HttpServletRequest)req);
                if (!isPerfUrl && this.needLog(req)) {
                    this.processAccessLog(req, (HttpServletResponse)servletResponse, startTime, collCookie);
                }
            }
            catch (Exception e) {
                log.error("AccessLogFilter process error, message=" + e.getMessage());
            }
            AppId.remove();
            ConsumerId.remove();
            LogCookie.remove();
            EX.remove();
            OverWrite.remove();
        }
    }

    private void addCookieIfNeed(HttpServletRequest req, HttpServletResponse resp, Map<String, String> collCookie) {
        Map params = req.getParameterMap();
        String host = req.getHeader(OW_HOST);
        String cookieHost = this.getCookieHost(host);
        for (String key : params.keySet()) {
            String verify;
            String[] v;
            if (!key.startsWith("tck_") || (v = key.split("_")).length != 3 || !(verify = SecurityUtils.encode2StringByMd5((String)v[1])).endsWith(v[2])) continue;
            String name = v[1];
            String value = req.getParameter(key);
            String cookiekey = "_coll_" + name;
            collCookie.put(cookiekey, value);
            Cookie cookie = new Cookie(cookiekey, value);
            if (cookieHost != null) {
                cookie.setDomain(cookieHost);
            }
            cookie.setPath("/");
            try {
                resp.addCookie(cookie);
            }
            catch (Exception e) {
                log.error("addCookie error,cookieKey=" + cookiekey + ",value=" + value, (Throwable)e);
            }
        }
    }

    private void processAccessLog(HttpServletRequest req, HttpServletResponse resp, long startTime, Map<String, String> collCookie) throws Exception {
        if (!this.isGetOrPost(req)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url_host", this.getHost(req));
        map.put("url_path", this.clearRequestURI(req.getRequestURI()));
        map.put("url_query", req.getQueryString());
        map.put("http_method", req.getMethod());
        map.put("rc", resp.getStatus());
        map.put("rt", System.currentTimeMillis() - startTime);
        map.put("mip", NetUtils.getLocalIp());
        this.putIfNotNull(map, "ex", EX.get());
        String callback = req.getParameter("callback");
        if (!StringUtils.isBlank((CharSequence)callback)) {
            map.put("http_method", "POST");
        }
        Map<String, Cookie> cookieMap = this.getCookieMap(req);
        Long consumerId = ConsumerId.get();
        Long appId = AppId.get();
        Cookie ac = cookieMap.get("_ac");
        if (ac != null && (consumerId == null || appId == null)) {
            try {
                String json = new String(SecurityUtils.decodeBase64((String)ac.getValue()), Charsets.UTF_8);
                if (json != null) {
                    JSONObject object = JSONObject.parseObject((String)json);
                    if (appId == null) {
                        appId = object.getLong("aid");
                    }
                    if (consumerId == null) {
                        consumerId = object.getLong("cid");
                    }
                }
            }
            catch (Exception e) {
                log.info("_ac decode fail , _ac= " + ac.getValue());
            }
        }
        this.putIfNotNull(map, "consumer_id", consumerId);
        this.putIfNotNull(map, "app_id", appId);
        this.handleCookies(cookieMap, collCookie);
        this.handleParams(req, resp, collCookie);
        this.handleLogCookie(collCookie);
        this.putIfNotEmpty(map, "cookie", collCookie);
        this.putUa(req, map);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("time", sdf.format(new Date()));
        String referer = req.getHeader("referer");
        this.putIfNotNull(map, "referer", referer);
        String ip = RequestTool.getIpAddr((HttpServletRequest)req);
        this.putIfNotNull(map, "ip", ip);
        accessLog.info(JSON.toJSONString(map));
    }

    private boolean isGetOrPost(HttpServletRequest req) {
        return "get".equalsIgnoreCase(req.getMethod()) || "post".equalsIgnoreCase(req.getMethod());
    }

    private void putUa(HttpServletRequest req, Map<String, Object> map) {
        String ua = StringUtils.trimToEmpty((String)req.getHeader("user-agent"));
        if (ua.length() > 500) {
            ua = ua.substring(0, 499);
        }
        if (!StringUtils.isEmpty((CharSequence)ua)) {
            map.put("user_agent", ua);
        }
    }

    private void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putIfNotEmpty(Map<String, Object> map, String key, Map<String, String> collCookie) {
        if (!collCookie.isEmpty()) {
            map.put(key, collCookie);
        }
    }

    private Map<String, Cookie> getCookieMap(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        if (cookies != null) {
            for (Cookie c : cookies) {
                cookieMap.put(c.getName(), c);
            }
        }
        return cookieMap;
    }

    private void handleCookies(Map<String, Cookie> cookieMap, Map<String, String> collCookie) {
        for (Map.Entry<String, Cookie> entry : cookieMap.entrySet()) {
            String key = entry.getKey();
            Cookie cookie = entry.getValue();
            if (!key.startsWith("_coll_")) continue;
            collCookie.put(key, cookie.getValue());
        }
    }

    private void handleParams(HttpServletRequest req, HttpServletResponse resp, Map<String, String> collCookie) {
        String deviceId;
        Map params = req.getParameterMap();
        String host = req.getHeader(OW_HOST);
        String cookieHost = this.getCookieHost(host);
        for (String key : params.keySet()) {
            String verify;
            String[] v;
            if (!key.startsWith("tck_") || (v = key.split("_")).length != 3 || !(verify = SecurityUtils.encode2StringByMd5((String)v[1])).endsWith(v[2])) continue;
            String name = v[1];
            String value = req.getParameter(key);
            String cookiekey = "_coll_" + name;
            collCookie.put(cookiekey, value);
            Cookie cookie = new Cookie(cookiekey, value);
            if (cookieHost != null) {
                cookie.setDomain(cookieHost);
            }
            cookie.setPath("/");
            resp.addCookie(cookie);
        }
        String slotId = req.getParameter("adslotId");
        if (slotId != null) {
            collCookie.put("_coll_slot", slotId);
        }
        if ((deviceId = req.getParameter("deviceId")) != null) {
            collCookie.put("_coll_device", deviceId);
        }
    }

    private void handleLogCookie(Map<String, String> collCookie) {
        Map<String, String> logCookie = LogCookie.get();
        if (logCookie != null) {
            for (Map.Entry<String, String> entry : logCookie.entrySet()) {
                collCookie.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private String clearRequestURI(String requestURI) {
        if (StringUtils.isBlank((CharSequence)requestURI)) {
            return requestURI;
        }
        return StringUtils.replace((String)requestURI, (String)"//", (String)"/");
    }

    private String getCookieHost(String host) {
        String cookieHost;
        if (host == null) {
            return null;
        }
        if (host.contains(":")) {
            host = host.substring(0, host.indexOf(58));
        }
        if ((cookieHost = this.cookieHosts.get(host)) != null) {
            return cookieHost;
        }
        String hostLow = host.toLowerCase();
        if (hostLow.endsWith(".duiba.com.cn")) {
            cookieHost = "duiba.com.cn";
        } else if (hostLow.endsWith(".dui88.com")) {
            cookieHost = "dui88.com";
        } else if (hostLow.endsWith(".duibar.com")) {
            cookieHost = "duibar.com";
        } else if (hostLow.endsWith(".tuia.cn")) {
            cookieHost = "tuia.cn";
        }
        if (cookieHost != null) {
            this.cookieHosts.put(host, cookieHost);
        }
        return cookieHost;
    }

    public void destroy() {
    }
}

