/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.DuibaRpcParamsInterceptor;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.DuibaTraceFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.DuibaTraceSecondFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.PercentageBasedSampler;
import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.ZipkinLogTurboFilter;
import javax.servlet.Filter;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.sleuth.Sampler;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.TraceFilter;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import zipkin2.Span;

@Configuration
@ConditionalOnClass(value={Span.class, ZipkinAutoConfiguration.class})
@EnableConfigurationProperties(value={SamplerProperties.class})
@AutoConfigureBefore(value={ZipkinAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.zipkin.enabled"}, matchIfMissing=true)
public class DuibaZipkinAutoConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private DuibaRpcParamsInterceptor interceptor;

    @Bean
    @ConditionalOnClass(value={TraceFilter.class})
    public Filter duibaTraceFilter() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.addTurboFilter((TurboFilter)new ZipkinLogTurboFilter());
        return new DuibaTraceFilter();
    }

    @Bean
    @ConditionalOnClass(value={TraceFilter.class, Tracer.class})
    public Filter duibaTracSecondFilter() {
        return new DuibaTraceSecondFilter();
    }

    @Bean
    @ConditionalOnClass(value={TraceFilter.class, Tracer.class})
    public DuibaRpcParamsInterceptor duibaRpcParamsInterceptor() {
        return new DuibaRpcParamsInterceptor();
    }

    @ConditionalOnClass(value={TraceFilter.class, Tracer.class})
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.interceptor).addPathPatterns(new String[]{"/**"});
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.cloud.context.config.annotation.RefreshScope"})
    protected static class NonRefreshScopePercentageBasedSamplerConfiguration {
        protected NonRefreshScopePercentageBasedSamplerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new PercentageBasedSampler(config);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RefreshScope.class})
    protected static class RefreshScopedPercentageBasedSamplerConfiguration {
        protected RefreshScopedPercentageBasedSamplerConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return new PercentageBasedSampler(config);
        }
    }
}

