/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd;

import cn.com.duibaboot.ext.autoconfigure.etcd.properties.EtcdProperties;
import com.coreos.jetcd.Client;
import com.coreos.jetcd.maintenance.StatusResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;

public class EtcdEndpoint
extends AbstractEndpoint<EtcdStatus> {
    private final Client etcdClient;
    private final EtcdProperties etcdProperties;

    public EtcdEndpoint(Client etcdClient, EtcdProperties etcdProperties) {
        super("etcd", true, true);
        this.etcdClient = etcdClient;
        this.etcdProperties = etcdProperties;
    }

    public EtcdStatus invoke() {
        List<EtcdMemberStatus> memberStatuses = this.etcdProperties.getUris().stream().map(endpoint -> {
            try {
                StatusResponse response = (StatusResponse)this.etcdClient.getMaintenanceClient().statusMember(endpoint).get();
                return new EtcdMemberStatus((String)endpoint, response.getVersion());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }).collect(Collectors.toList());
        return new EtcdStatus(memberStatuses);
    }

    static class EtcdMemberStatus {
        private String endpoint;
        private String version;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getVersion() {
            return this.version;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EtcdMemberStatus)) {
                return false;
            }
            EtcdMemberStatus other = (EtcdMemberStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EtcdMemberStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 0 : $endpoint.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 0 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "EtcdEndpoint.EtcdMemberStatus(endpoint=" + this.getEndpoint() + ", version=" + this.getVersion() + ")";
        }

        public EtcdMemberStatus() {
        }

        @ConstructorProperties(value={"endpoint", "version"})
        public EtcdMemberStatus(String endpoint, String version) {
            this.endpoint = endpoint;
            this.version = version;
        }
    }

    static class EtcdStatus {
        private List<EtcdMemberStatus> members;

        public List<EtcdMemberStatus> getMembers() {
            return this.members;
        }

        public void setMembers(List<EtcdMemberStatus> members) {
            this.members = members;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EtcdStatus)) {
                return false;
            }
            EtcdStatus other = (EtcdStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<EtcdMemberStatus> this$members = this.getMembers();
            List<EtcdMemberStatus> other$members = other.getMembers();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EtcdStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<EtcdMemberStatus> $members = this.getMembers();
            result = result * 59 + ($members == null ? 0 : ((Object)$members).hashCode());
            return result;
        }

        public String toString() {
            return "EtcdEndpoint.EtcdStatus(members=" + this.getMembers() + ")";
        }

        public EtcdStatus() {
        }

        @ConstructorProperties(value={"members"})
        public EtcdStatus(List<EtcdMemberStatus> members) {
            this.members = members;
        }
    }
}

