/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd;

import com.coreos.jetcd.Client;
import com.coreos.jetcd.data.ByteSequence;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class EtcdHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(EtcdHealthIndicator.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdHealthIndicator.class);
    private final Client etcdClient;

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            String randomKey = UUID.randomUUID().toString();
            this.etcdClient.getKVClient().get(ByteSequence.fromString((String)randomKey)).get(5L, TimeUnit.SECONDS);
            builder.up();
        }
        catch (Exception e) {
            LOGGER.error("EtcdHealthIndicator error ", (Throwable)e);
            builder.down();
        }
    }

    @ConstructorProperties(value={"etcdClient"})
    public EtcdHealthIndicator(Client etcdClient) {
        this.etcdClient = etcdClient;
    }
}

