/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping;

import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.filter.ServiceGroupFilter;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.netflix.hystrix.HystrixCommand;
import feign.RequestInterceptor;
import feign.hystrix.HystrixFeign;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@ConditionalOnClass(value={TransmittableThreadLocal.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class ServiceGroupAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
    public class ServiceGroupFeignConfiguration {
        @Bean
        public RequestInterceptor serviceGroupFeignRequestInterceptor() {
            return template -> {
                String groupKey = ServiceGroupContext.getCurrentGroupKey();
                if (StringUtils.isNotBlank((CharSequence)groupKey)) {
                    template.header("_duibaServiceGroupKey", new String[]{groupKey});
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    @ConditionalOnWebApplication
    static class ServiceGroupFilterConfiguration {
        ServiceGroupFilterConfiguration() {
        }

        @Bean
        public ServiceGroupFilter serviceGroupFilter() {
            return new ServiceGroupFilter();
        }

        @Bean
        public FilterRegistrationBean serviceGroupFilterConfigurer(ServiceGroupFilter serviceGroupFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)serviceGroupFilter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-2147483644);
            return registrationBean;
        }
    }
}

