/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duiba.boot.utils.JarVersionUtils;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PerfTestRibbonServerListFilter
implements RibbonServerListFilter {
    public List<Server> filter(List<Server> serverList, Object key) {
        String dependencyAppName;
        if (serverList.isEmpty()) {
            return serverList;
        }
        for (Server s : serverList) {
            if (s instanceof DiscoveryEnabledServer) continue;
            return serverList;
        }
        boolean perfTestMode = InternalPerfTestContext.isCurrentInPerfTestMode();
        String contextSceneId = InternalPerfTestContext.getCurrentSceneId();
        boolean isTestCluster = InternalPerfTestContext.isTestCluster();
        ArrayList<Server> retList = new ArrayList<Server>();
        for (Server server : serverList) {
            String serverPerfSceneId = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("duiba.perf.scene.id");
            if (perfTestMode && isTestCluster) {
                String duibaBootVersion;
                if (!this.sceneIdEquals(contextSceneId, serverPerfSceneId) || !JarVersionUtils.isJarVersionEqualOrGreaterThan((String)(duibaBootVersion = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("duibaBootVersion")), (String)"1.2.251")) continue;
                retList.add(server);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)serverPerfSceneId)) continue;
            retList.add(server);
        }
        if (retList.isEmpty() && perfTestMode && !"ZIPKIN-SERVER".equals(dependencyAppName = ((DiscoveryEnabledServer)serverList.get(0)).getInstanceInfo().getAppName())) {
            throw new IllegalStateException("ribbon\u8fc7\u6ee4\u670d\u52a1\u5668\u65f6\u68c0\u6d4b\u5230\u5f53\u524d\u8bf7\u6c42\u4e3a\u5e26\u6709\u538b\u6d4b\u573a\u666fID\u7684\u8bf7\u6c42\uff0c\u4f46\u662f\u6ca1\u6709\u627e\u5230" + dependencyAppName + "\u7684\u538b\u6d4b\u4e13\u7528\u5b9e\u4f8b(ext>=1.2.234)\uff0c\u62d2\u7edd\u8c03\u7528\u3002\uff08\u538b\u6d4b\u573a\u666fID:" + contextSceneId + "\uff09");
        }
        return retList.isEmpty() ? serverList : retList;
    }

    private boolean sceneIdEquals(String contextSceneId, String serverSceneId) {
        if (contextSceneId == null || serverSceneId == null) {
            return false;
        }
        return contextSceneId.equals(serverSceneId);
    }
}

