/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.MessageListenerConcurrentlyWrapper;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.MessageListenerOrderlyWrapper;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RocketMqMessageListenerPostProcessor4Group
implements SpecifiedBeanPostProcessor<MessageListener>,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RocketMqMessageListenerPostProcessor4Group.class);
    private ApplicationContext applicationContext;
    @Value(value="${duiba.service.group.key:}")
    private String currentServerGroupKey;

    @Override
    public Class<MessageListener> getBeanType() {
        return MessageListener.class;
    }

    @Override
    public Object postProcessBeforeInitialization(MessageListener bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(MessageListener bean, String beanName) throws BeansException {
        if (Arrays.stream(this.applicationContext.getEnvironment().getActiveProfiles()).filter(s -> s.startsWith("prod")).findAny().isPresent()) {
            return bean;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget((Object)bean);
        factory.addAdvice((Advice)new MessageListenerMethodInterceptor(this.currentServerGroupKey, this.applicationContext));
        return factory.getProxy();
    }

    public int getOrder() {
        return 0;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class MessageListenerMethodInterceptor
    implements MethodInterceptor {
        private String currentServerGroupKey;
        private ApplicationContext applicationContext;
        private volatile HazelcastInstance hazelcastInstance;

        MessageListenerMethodInterceptor(String currentServerGroupKey, ApplicationContext applicationContext) {
            this.currentServerGroupKey = currentServerGroupKey;
            this.applicationContext = applicationContext;
        }

        private HazelcastInstance getHazelcastInstance() {
            if (this.hazelcastInstance == null) {
                this.hazelcastInstance = (HazelcastInstance)this.applicationContext.getBean("hazelcastInstance", HazelcastInstance.class);
            }
            return this.hazelcastInstance;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.startsWith("consumeMessage") && invocation.getMethod().getParameterTypes().length >= 1 && invocation.getMethod().getParameterTypes()[0].equals(List.class)) {
                String beanName = this.resolveBeanName(invocation.getThis());
                if (beanName == null) {
                    return invocation.proceed();
                }
                Object[] args = invocation.getArguments();
                List list = (List)args[0];
                Object messageContext = args[1];
                if (list != null && list.size() == 1) {
                    MessageExt m = (MessageExt)list.get(0);
                    return this.consumeOne(invocation, m, beanName, messageContext);
                }
                if (list != null && list.size() > 1 && this.containsServiceGroupMsg(list)) {
                    logger.warn("\u3010\u591a\u573a\u666f\u6d4b\u8bd5\u65e0\u6cd5\u652f\u6301\u4e00\u6b21\u6d88\u8d39\u591a\u6761rocketmq\u6d88\u606f\u3011\u68c0\u6d4b\u5230\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u591a\u573a\u666f\u6d4b\u8bd5\uff0crocketmq\u6d88\u8d39\u8005\u4e00\u6b21\u6d88\u8d39\u4e86\u591a\u6761\u6d88\u606f\u4e14\u6d88\u606f\u4e2d\u6709\u591a\u573a\u666f\u6d4b\u8bd5\u6d88\u606f\uff08\u5982\u9700\u652f\u6301\u591a\u573a\u666f\u6d88\u8d39\u8bf7\u8bbe\u7f6eDefaultMQPushConsumer.setConsumeMessageBatchMaxSize \u4e3a1\uff09");
                }
            }
            return invocation.proceed();
        }

        private String resolveBeanName(Object obj) {
            if (obj instanceof MessageListenerConcurrentlyWrapper) {
                return ((MessageListenerConcurrentlyWrapper)obj).getBeanName();
            }
            if (obj instanceof MessageListenerOrderlyWrapper) {
                return ((MessageListenerOrderlyWrapper)obj).getBeanName();
            }
            logger.warn("\u65e0\u6cd5\u83b7\u53d6beanName\uff0c\u65e0\u6cd5\u652f\u6301rocketmq\u591a\u573a\u666f\u6d4b\u8bd5\uff0c\u5e94\u8be5\u662fBeanPostProcessor\u987a\u5e8f\u4e71\u4e86\u5bfc\u81f4\u7684");
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object consumeOne(MethodInvocation invocation, MessageExt m, String beanName, Object messageContext) throws Throwable {
            String serviceGroupKeyOfMessage = m.getUserProperty("_duibaServiceGroupKey");
            if (StringUtils.isNotBlank((CharSequence)serviceGroupKeyOfMessage)) {
                if (serviceGroupKeyOfMessage.equals(this.currentServerGroupKey)) {
                    ServiceGroupContext.setGroupKey(serviceGroupKeyOfMessage);
                    try {
                        Object object = invocation.proceed();
                        return object;
                    }
                    finally {
                        ServiceGroupContext.removeGroupKey();
                    }
                }
                Member selectedMember = this.getHazelcastInstance().getCluster().getMembers().stream().filter(member -> {
                    String memberServiceGroupKey = member.getStringAttribute("duiba.service.group.key");
                    return serviceGroupKeyOfMessage.equals(memberServiceGroupKey);
                }).findAny().orElseGet(() -> {
                    if (StringUtils.isBlank((CharSequence)this.currentServerGroupKey)) {
                        return null;
                    }
                    return this.getHazelcastInstance().getCluster().getMembers().stream().filter(member -> {
                        String memberServiceGroupKey = member.getStringAttribute("duiba.service.group.key");
                        return StringUtils.isBlank((CharSequence)memberServiceGroupKey);
                    }).findAny().orElse(null);
                });
                if (selectedMember != null) {
                    return this.submitConsumeTask2otherNode(m, messageContext, beanName, selectedMember);
                }
                ServiceGroupContext.setGroupKey(serviceGroupKeyOfMessage);
                try {
                    Object object = invocation.proceed();
                    return object;
                }
                finally {
                    ServiceGroupContext.removeGroupKey();
                }
            }
            if (StringUtils.isBlank((CharSequence)this.currentServerGroupKey)) {
                return invocation.proceed();
            }
            Member selectedMember = this.getHazelcastInstance().getCluster().getMembers().stream().filter(member -> {
                String memberServiceGroupKey = member.getStringAttribute("duiba.service.group.key");
                return StringUtils.isBlank((CharSequence)memberServiceGroupKey);
            }).findAny().orElse(null);
            if (selectedMember != null) {
                return this.submitConsumeTask2otherNode(m, messageContext, beanName, selectedMember);
            }
            return invocation.proceed();
        }

        private Object submitConsumeTask2otherNode(MessageExt m, Object messageContext, String beanName, Member selectedMember) throws ExecutionException, RejectedExecutionException, InterruptedException {
            ConsumeConcurrentlyContext c;
            IExecutorService executorService = this.getHazelcastInstance().getExecutorService("rocketmq-consume");
            RocketMqRunInOtherNodeTask.RocketMqRunInOtherNodeTaskBuilder builder = RocketMqRunInOtherNodeTask.builder().beanName(beanName).msgs(Arrays.asList(m));
            if (messageContext instanceof ConsumeConcurrentlyContext) {
                c = (ConsumeConcurrentlyContext)messageContext;
                builder.messageQueue(c.getMessageQueue());
                builder.ackIndex(c.getAckIndex());
                builder.delayLevelWhenNextConsume(c.getDelayLevelWhenNextConsume());
            } else if (messageContext instanceof ConsumeOrderlyContext) {
                c = (ConsumeOrderlyContext)messageContext;
                builder.messageQueue(c.getMessageQueue());
                builder.suspendCurrentQueueTimeMillis(c.getSuspendCurrentQueueTimeMillis());
                builder.autoCommit(c.isAutoCommit());
            }
            RocketMqRunInOtherNodeTask task = builder.build();
            Future future = executorService.submitToMember((Callable)task, selectedMember);
            return future.get();
        }

        private boolean containsServiceGroupMsg(List<MessageExt> list) {
            return list.stream().filter(messageExt -> StringUtils.isNotBlank((CharSequence)messageExt.getUserProperty("_duibaServiceGroupKey"))).count() > 0L;
        }

        static class RocketMqRunInOtherNodeTask
        implements Callable<Object>,
        Serializable,
        HazelcastInstanceAware {
            @Resource
            private transient ApplicationContext applicationContext;
            private String beanName;
            private List<MessageExt> msgs;
            private MessageQueue messageQueue;
            private int delayLevelWhenNextConsume;
            private int ackIndex;
            private boolean autoCommit = true;
            private long suspendCurrentQueueTimeMillis = -1L;

            public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
                ApplicationContext applicationContext = (ApplicationContext)hazelcastInstance.getUserContext().get("applicationContext");
                applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)this);
            }

            @Override
            public Object call() throws Exception {
                MessageListener listener;
                try {
                    listener = (MessageListener)this.applicationContext.getBean(this.beanName, MessageListener.class);
                }
                catch (BeanNotOfRequiredTypeException | NoSuchBeanDefinitionException e) {
                    throw new IllegalStateException("\u627e\u4e0d\u5230beanName\u4e3a" + this.beanName + "\u7684messageListener\uff0c\u65e0\u6cd5\u6d88\u8d39\u591a\u573a\u666f\u7684rocketmq\u6d88\u606f\uff1b\u591a\u573a\u666f\u6d4b\u8bd5\u65f6\u8bf7\u81f3\u5c11\u4fdd\u8bc1\u9879\u76ee\u5404\u4e2a\u5206\u652f\u6709\u4e00\u6837\u540d\u5b57\u7684MessageListener", e);
                }
                if (listener instanceof MessageListenerConcurrently) {
                    ConsumeConcurrentlyContext consumeConcurrentlyContext = new ConsumeConcurrentlyContext(this.messageQueue);
                    consumeConcurrentlyContext.setAckIndex(this.ackIndex);
                    consumeConcurrentlyContext.setDelayLevelWhenNextConsume(this.delayLevelWhenNextConsume);
                    return ((MessageListenerConcurrently)listener).consumeMessage(this.msgs, consumeConcurrentlyContext);
                }
                if (listener instanceof MessageListenerOrderly) {
                    ConsumeOrderlyContext consumeOrderlyContext = new ConsumeOrderlyContext(this.messageQueue);
                    consumeOrderlyContext.setAutoCommit(this.autoCommit);
                    consumeOrderlyContext.setSuspendCurrentQueueTimeMillis(this.suspendCurrentQueueTimeMillis);
                    return ((MessageListenerOrderly)listener).consumeMessage(this.msgs, consumeOrderlyContext);
                }
                throw new UnsupportedOperationException("\u6682\u672a\u652f\u6301\u7684MessageListener\u7c7b\u578b\uff1a" + listener.getClass().getName());
            }

            RocketMqRunInOtherNodeTask(ApplicationContext applicationContext, String beanName, List<MessageExt> msgs, MessageQueue messageQueue, int delayLevelWhenNextConsume, int ackIndex, boolean autoCommit, long suspendCurrentQueueTimeMillis) {
                this.applicationContext = applicationContext;
                this.beanName = beanName;
                this.msgs = msgs;
                this.messageQueue = messageQueue;
                this.delayLevelWhenNextConsume = delayLevelWhenNextConsume;
                this.ackIndex = ackIndex;
                this.autoCommit = autoCommit;
                this.suspendCurrentQueueTimeMillis = suspendCurrentQueueTimeMillis;
            }

            public static RocketMqRunInOtherNodeTaskBuilder builder() {
                return new RocketMqRunInOtherNodeTaskBuilder();
            }

            public static class RocketMqRunInOtherNodeTaskBuilder {
                private ApplicationContext applicationContext;
                private String beanName;
                private List<MessageExt> msgs;
                private MessageQueue messageQueue;
                private int delayLevelWhenNextConsume;
                private int ackIndex;
                private boolean autoCommit;
                private long suspendCurrentQueueTimeMillis;

                RocketMqRunInOtherNodeTaskBuilder() {
                }

                public RocketMqRunInOtherNodeTaskBuilder applicationContext(ApplicationContext applicationContext) {
                    this.applicationContext = applicationContext;
                    return this;
                }

                public RocketMqRunInOtherNodeTaskBuilder beanName(String beanName) {
                    this.beanName = beanName;
                    return this;
                }

                public RocketMqRunInOtherNodeTaskBuilder msgs(List<MessageExt> msgs) {
                    this.msgs = msgs;
                    return this;
                }

                public RocketMqRunInOtherNodeTaskBuilder messageQueue(MessageQueue messageQueue) {
                    this.messageQueue = messageQueue;
                    return this;
                }

                public RocketMqRunInOtherNodeTaskBuilder delayLevelWhenNextConsume(int delayLevelWhenNextConsume) {
                    this.delayLevelWhenNextConsume = delayLevelWhenNextConsume;
                    return this;
                }

                public RocketMqRunInOtherNodeTaskBuilder ackIndex(int ackIndex) {
                    this.ackIndex = ackIndex;
                    return this;
                }

                public RocketMqRunInOtherNodeTaskBuilder autoCommit(boolean autoCommit) {
                    this.autoCommit = autoCommit;
                    return this;
                }

                public RocketMqRunInOtherNodeTaskBuilder suspendCurrentQueueTimeMillis(long suspendCurrentQueueTimeMillis) {
                    this.suspendCurrentQueueTimeMillis = suspendCurrentQueueTimeMillis;
                    return this;
                }

                public RocketMqRunInOtherNodeTask build() {
                    return new RocketMqRunInOtherNodeTask(this.applicationContext, this.beanName, this.msgs, this.messageQueue, this.delayLevelWhenNextConsume, this.ackIndex, this.autoCommit, this.suspendCurrentQueueTimeMillis);
                }

                public String toString() {
                    return "RocketMqMessageListenerPostProcessor4Group.MessageListenerMethodInterceptor.RocketMqRunInOtherNodeTask.RocketMqRunInOtherNodeTaskBuilder(applicationContext=" + this.applicationContext + ", beanName=" + this.beanName + ", msgs=" + this.msgs + ", messageQueue=" + this.messageQueue + ", delayLevelWhenNextConsume=" + this.delayLevelWhenNextConsume + ", ackIndex=" + this.ackIndex + ", autoCommit=" + this.autoCommit + ", suspendCurrentQueueTimeMillis=" + this.suspendCurrentQueueTimeMillis + ")";
                }
            }
        }
    }
}

