/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.StaticMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.loader.InterceptorInstanceLoader;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMethodsInter {
    private static final Logger logger = LoggerFactory.getLogger(StaticMethodsInter.class);
    private String staticMethodsAroundInterceptorClassName;

    public StaticMethodsInter(String staticMethodsAroundInterceptorClassName) {
        this.staticMethodsAroundInterceptorClassName = staticMethodsAroundInterceptorClassName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public Object intercept(@Origin Class<?> clazz, @AllArguments Object[] allArguments, @Origin Method method, @SuperCall Callable<?> zuper) throws Throwable {
        StaticMethodsAroundInterceptor interceptor = (StaticMethodsAroundInterceptor)InterceptorInstanceLoader.load(this.staticMethodsAroundInterceptorClassName, clazz.getClassLoader());
        MethodInterceptResult result = new MethodInterceptResult();
        try {
            interceptor.beforeMethod(clazz, method, allArguments, method.getParameterTypes(), result);
        }
        catch (Throwable t) {
            logger.error("class[{}] before static method[{}] intercept failure", new Object[]{clazz, method.getName(), t});
        }
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call();
        }
        catch (Throwable t) {
            try {
                try {
                    interceptor.handleMethodException(clazz, method, allArguments, method.getParameterTypes(), t);
                    throw t;
                }
                catch (Throwable t2) {
                    logger.error("class[{}] handle static method[{}] exception failure", new Object[]{clazz, method.getName(), t2});
                }
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    ret = interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
                    throw throwable;
                }
                catch (Throwable t2) {
                    logger.error("class[{}] after static method[{}] intercept failure:{}", new Object[]{clazz, method.getName(), t2});
                }
                throw throwable;
            }
        }
        try {
            return interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
        }
        catch (Throwable t) {
            logger.error("class[{}] after static method[{}] intercept failure:{}", new Object[]{clazz, method.getName(), t});
            return ret;
        }
    }
}

