/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.utils;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    private FileUtils() {
    }

    public static boolean rename(File file, String newName) {
        boolean deleted;
        if (!file.exists()) {
            throw new IllegalArgumentException("\u539f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (StringUtils.equals((String)file.getName(), (String)newName)) {
            throw new IllegalArgumentException("\u539f\u6587\u4ef6\u540d\u4e0e\u8981\u91cd\u547d\u540d\u7684\u76ee\u6807\u6587\u4ef6\u540d\u76f8\u540c");
        }
        String path = file.getParent();
        String newfileName = path + "/" + newName;
        File dest = new File(newfileName);
        if (dest.exists() && !(deleted = dest.delete())) {
            return false;
        }
        return file.renameTo(dest);
    }

    public static String getFileName(File file) {
        if (!file.exists()) {
            return "";
        }
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public static String getFileSuffix(File file) {
        if (!file.exists()) {
            return "";
        }
        return FileUtils.getFileSuffix(file.getName(), true);
    }

    public static String getFileSuffix(String fileName, boolean hasPoint) {
        if (StringUtils.isBlank((String)fileName)) {
            return "";
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        if (!hasPoint) {
            ++index;
        }
        return fileName.substring(index);
    }

    public static List<File> findAllFileByRootPath(File rootPath) {
        if (!rootPath.exists()) {
            return Collections.emptyList();
        }
        if (!rootPath.isDirectory()) {
            return Lists.newArrayList((Object[])new File[]{rootPath});
        }
        ArrayList returnList = Lists.newArrayList();
        LinkedList list = Lists.newLinkedList();
        File[] files = rootPath.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            if (file.isDirectory()) {
                list.add(file);
                continue;
            }
            returnList.add(file);
        }
        while (!list.isEmpty()) {
            File tempFile = (File)list.removeFirst();
            files = tempFile.listFiles();
            for (File file : Objects.requireNonNull(files)) {
                if (file.isDirectory()) {
                    list.add(file);
                    continue;
                }
                returnList.add(file);
            }
        }
        return returnList;
    }
}

