/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.WitnessClassFinder;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.dynamic.DynamicType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassEnhancePluginDefine {
    private final Logger logger = LoggerFactory.getLogger((String)AbstractClassEnhancePluginDefine.class.getName());

    public DynamicType.Builder define(String transformClassName, DynamicType.Builder builder, ClassLoader classLoader) throws PluginException {
        String[] witnessClasses;
        String interceptorDefineClassName = this.getClass().getName();
        if (StringUtils.isEmpty((String)transformClassName)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("classname of being intercepted is not defined by " + interceptorDefineClassName);
            }
            return null;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("prepare to enhance class " + transformClassName + " by " + interceptorDefineClassName);
        }
        if ((witnessClasses = this.witnessClasses()) != null) {
            for (String witnessClass : witnessClasses) {
                if (WitnessClassFinder.INSTANCE.exist(witnessClass, classLoader)) continue;
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("enhance class " + transformClassName + " by plugin " + interceptorDefineClassName + " is not working. Because witness class " + witnessClass + " is not existed.");
                }
                return null;
            }
        }
        DynamicType.Builder newClassBuilder = this.enhance(transformClassName, builder, classLoader);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("enhance class " + transformClassName + " by " + interceptorDefineClassName + " completely.");
        }
        return newClassBuilder;
    }

    protected abstract DynamicType.Builder enhance(String var1, DynamicType.Builder var2, ClassLoader var3) throws PluginException;

    protected abstract ClassMatch enhanceClass();

    protected String[] witnessClasses() {
        return new String[0];
    }
}

