/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.HystrixDisabled;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix.FeignClientException;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import com.alibaba.fastjson.JSONObject;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignErrorDecoder
implements ErrorDecoder {
    private static final Logger logger = LoggerFactory.getLogger(FeignErrorDecoder.class);
    private final RetryAfterDecoder retryAfterDecoder = new RetryAfterDecoder();

    public Exception decode(String methodKey, Response response) {
        FeignClientException exception;
        block12: {
            try {
                if (response.body() != null) {
                    String body = Util.toString((Reader)response.body().asReader());
                    JSONObject jsonObj = JSONObject.parseObject((String)body);
                    String exceptionClassStr = jsonObj.getString("exception");
                    Class<?> exceptionClass = null;
                    if (exceptionClassStr != null) {
                        try {
                            exceptionClass = Class.forName(exceptionClassStr);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (exceptionClass != null) {
                        exception = BizException.class.isAssignableFrom(exceptionClass) ? new BizException(jsonObj.getString("message")).withCode(jsonObj.getString("code")) : this.genFeignException(response.status(), methodKey, body);
                        if (IllegalArgumentException.class.isAssignableFrom(exceptionClass) || exceptionClass.isAnnotationPresent(HystrixDisabled.class) || this.isInMethodIgnoreExceptions(RpcContext.getContext().getMethod(), exceptionClass)) {
                            exception = new HystrixBadRequestException(((Throwable)((Object)exception)).getMessage(), (Throwable)((Object)exception));
                        } else if (RejectedExecutionException.class.isAssignableFrom(exceptionClass)) {
                            exception = new RetryableException(((Throwable)((Object)exception)).getMessage(), (Throwable)new RejectedExecutionException(((Throwable)((Object)exception)).getMessage(), (Throwable)((Object)exception)), null);
                        }
                    } else {
                        exception = this.genFeignException(response.status(), methodKey, body);
                    }
                    break block12;
                }
                exception = this.genFeignException(response.status(), methodKey, null);
            }
            catch (IOException ignored) {
                exception = this.genFeignException(response.status(), methodKey, null);
            }
        }
        Date retryAfter = this.retryAfterDecoder.apply((String)this.firstOrNull(response.headers(), "Retry-After"));
        if (retryAfter != null) {
            return new RetryableException(((Throwable)((Object)exception)).getMessage(), (Throwable)((Object)exception), retryAfter);
        }
        return exception;
    }

    private boolean isInMethodIgnoreExceptions(Method method, Class exceptionClass) {
        FeignHystrixCommand commandOfMethod = method.getAnnotation(FeignHystrixCommand.class);
        FeignHystrixCommand commandOfClass = method.getDeclaringClass().getAnnotation(FeignHystrixCommand.class);
        return this.isInIgnoreExceptions(commandOfMethod, exceptionClass) || this.isInIgnoreExceptions(commandOfClass, exceptionClass);
    }

    private boolean isInIgnoreExceptions(FeignHystrixCommand command, Class exceptionClass) {
        Class[] classes;
        if (command != null && (classes = command.ignoreExceptions()) != null) {
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(exceptionClass)) continue;
                return true;
            }
        }
        return false;
    }

    private <T> T firstOrNull(Map<String, Collection<T>> map, String key) {
        if (map.containsKey(key) && !map.get(key).isEmpty()) {
            return map.get(key).iterator().next();
        }
        return null;
    }

    private FeignClientException genFeignException(int status, String methodKey, String responseBody) {
        String message = String.format("status %s reading %s", status, methodKey);
        message = message + "; content:\n" + responseBody;
        return new FeignClientException(status, message);
    }

    static class RetryAfterDecoder {
        static final DateFormat RFC822_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        private final DateFormat rfc822Format;

        RetryAfterDecoder() {
            this(RFC822_FORMAT);
        }

        RetryAfterDecoder(DateFormat rfc822Format) {
            this.rfc822Format = (DateFormat)Util.checkNotNull((Object)rfc822Format, (String)"rfc822Format", (Object[])new Object[0]);
        }

        protected long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date apply(String retryAfter) {
            if (retryAfter == null) {
                return null;
            }
            if (retryAfter.matches("^[0-9]+$")) {
                long deltaMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter));
                return new Date(this.currentTimeMillis() + deltaMillis);
            }
            DateFormat dateFormat = this.rfc822Format;
            synchronized (dateFormat) {
                try {
                    return this.rfc822Format.parse(retryAfter);
                }
                catch (ParseException ignored) {
                    return null;
                }
            }
        }
    }
}

