/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.alibaba.dubbo.common.URL;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.feign.FeignClientFactoryBean;

public class CustomFeignClientFactoryBean
extends FeignClientFactoryBean {
    @Value(value="${spring.application.name}")
    private String springApplicationName;

    public Object getObject() throws Exception {
        Class classType = super.getObjectType();
        Object obj = super.getObject();
        return Proxy.newProxyInstance(classType.getClassLoader(), new Class[]{classType}, (InvocationHandler)new FeignClientInvocationHandler(this.springApplicationName, obj));
    }

    @VisibleForTesting
    public static class FeignClientInvocationHandler
    implements InvocationHandler {
        private String springApplicationName;
        private static final ThreadLocal<Cat.Context> CAT_CONTEXT = new ThreadLocal();
        private Object original;

        FeignClientInvocationHandler(String springApplicationName, Object original) {
            this.springApplicationName = springApplicationName;
            this.original = original;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName) || method.isDefault()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            RpcContext.getContext().setMethod(method);
            if (!CatUtils.isCatEnabled()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            String loggerName = method.getDeclaringClass().getSimpleName() + "." + method.getName();
            Transaction transaction = Cat.newTransaction((String)"PigeonCall", (String)loggerName);
            try {
                Cat.Context context = this.getContext();
                Cat.logRemoteCallClient((Cat.Context)context);
                this.setAttachment(context, method);
                Object result = this.invokeMethodInner(method, this.original, args);
                transaction.setStatus("0");
                Object object = result;
                return object;
            }
            catch (Throwable e) {
                if (!(e instanceof BizException)) {
                    Cat.logError((Throwable)e);
                    transaction.setStatus(e);
                } else {
                    transaction.setStatus(String.format("BizException(message:%s,code:%s)(this exception will not trigger hystrix)", e.getMessage(), ((BizException)e).getCode()));
                }
                throw e;
            }
            finally {
                CatUtils.completeTransaction(transaction);
                CAT_CONTEXT.remove();
            }
        }

        private Object invokeMethodInner(Method method, Object target, Object[] args) throws Throwable {
            try {
                return method.invoke(target, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (e instanceof HystrixBadRequestException && e.getCause() != null && e.getCause() instanceof BizException) {
                    e = e.getCause();
                }
                throw e;
            }
        }

        private String getProviderAppName(URL url) {
            String appName = url.getParameter("serverApplicationName");
            if (StringUtils.isEmpty((String)appName)) {
                String interfaceName = url.getParameter("interface");
                appName = interfaceName.substring(0, interfaceName.lastIndexOf(46));
            }
            return appName;
        }

        private void setAttachment(Cat.Context context, Method method) {
            RpcContext.getContext().setAttachment("_catRootMessageId", context.getProperty("_catRootMessageId"));
            RpcContext.getContext().setAttachment("_catChildMessageId", context.getProperty("_catChildMessageId"));
            RpcContext.getContext().setAttachment("_catParentMessageId", context.getProperty("_catParentMessageId"));
            RpcContext.getContext().setAttachment("X-Rpc-Client", this.springApplicationName);
        }

        private Cat.Context getContext() {
            Cat.Context context = CAT_CONTEXT.get();
            if (context == null) {
                context = new RpcCatContext();
                CAT_CONTEXT.set(context);
            }
            return context;
        }

        private void createConsumerCross(URL url, Transaction transaction) {
            Event crossAppEvent = Cat.newEvent((String)"PigeonCall.app", (String)this.getProviderAppName(url));
            Event crossServerEvent = Cat.newEvent((String)"PigeonCall.server", (String)url.getHost());
            Event crossPortEvent = Cat.newEvent((String)"PigeonCall.port", (String)(url.getPort() + ""));
            this.completeEvent(crossAppEvent);
            this.completeEvent(crossPortEvent);
            this.completeEvent(crossServerEvent);
            transaction.addChild((Message)crossAppEvent);
            transaction.addChild((Message)crossPortEvent);
            transaction.addChild((Message)crossServerEvent);
        }

        private void completeEvent(Event event) {
            AbstractMessage message = (AbstractMessage)event;
            message.setCompleted(true);
            message.setStatus("0");
        }

        private static class RpcCatContext
        implements Cat.Context {
            private Map<String, String> properties = new HashMap<String, String>();

            private RpcCatContext() {
            }

            public void addProperty(String key, String value) {
                this.properties.put(key, value);
            }

            public String getProperty(String key) {
                return this.properties.get(key);
            }
        }
    }
}

