package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.KryoSerializer;

import java.lang.reflect.Method;

/**
 * caffeine缓存类型的span
 * Created by guoyanfei .
 * 2019-04-15 .
 */
public class CaffeineCacheFlowReplaySpan extends FlowReplaySpan {

    private static final long serialVersionUID = 4625240016356029449L;

    /**
     * 方法名称
     */
    private String methodName;

    /**
     * 参数类型数组
     */
    private String[] parameterTypes;

    /**
     * 参数值数组
     */
    private byte[] parameterValues;

    /**
     * 返回值
     */
    private byte[] returnValue;

    @Override
    public SpanType getSpanType() {
        return SpanType.CAFFEINE_CACHE;
    }

    /**
     * 创建span
     * @param method
     * @param allArguments
     * @param argumentsTypes
     * @param ret
     * @return
     */
    public static CaffeineCacheFlowReplaySpan createSpan(Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        String[] parameterTypes = null;
        if (argumentsTypes.length > 0) {
            parameterTypes = new String[argumentsTypes.length];
            for (int i = 0; i < argumentsTypes.length; i++) {
                parameterTypes[i] = argumentsTypes[i].getName();
            }
        }
        CaffeineCacheFlowReplaySpan span = new CaffeineCacheFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.methodName = method.getName();
        span.parameterTypes = parameterTypes;
        span.parameterValues = KryoSerializer.serialize(allArguments);
        span.returnValue = KryoSerializer.serialize(ret);
        return span;
    }

    public String getMethodName() {
        return methodName;
    }

    public String[] getParameterTypes() {
        return parameterTypes;
    }

    public Object[] getParameterValues() {
        return (Object[]) KryoSerializer.deserialize(parameterValues);
    }

    public Object getReturnValue() {
        return KryoSerializer.deserialize(returnValue);
    }
}
