package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * 回放结果构建器
 * Created by guoyanfei .
 * 2019-02-25 .
 */
@Slf4j
public class ReplayResultBuilder {

    @Resource
    private FlowReplayFileComponent flowReplayFileComponent;

    /**
     * 监听"回放结束"事件
     * @param event
     * @throws IOException
     */
    @EventListener(ReplayEndEvent.class)
    public void replayEndEventListener(ReplayEndEvent event) throws IOException {
        new Thread(new Runnable() {

            @Override
            public void run() {
                ReplayContext context = ReplayContextHolder.getReplayContext();
                if (context == null) {
                    return;
                }
                String ossPath = null;
                try {
                    ossPath = flowReplayFileComponent.upload(FlowReplayConstants.LOCAL_RESULT_FILEPATH);
                } catch (IOException e) {
                    log.error("回放报告上传异常", e);
                }

                ReplayResult result = new ReplayResult(context.getReportId(), ossPath, context.getStartTime(), context.getEndTime());
                context.setReplayResult(result);
            }
        }, "DBThread-Replay-Upload").start();

    }
}
