package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.FlowReplayTraceMapHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.ReplayTraceContextMapHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.SpringMvcReplayer;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * Spring Mvc 回放的过滤器。用于设置回放的trace上下文
 * Created by guoyanfei .
 * 2019-03-14 .
 */
public class ReplaySpringMvcFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        // do nothing
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest) request;
        String traceId = req.getHeader(SpringMvcReplayer.TRACE_ID);
        if (FlowReplayUtils.isReplayEnv() && StringUtils.isNotBlank(traceId)) {
            FlowReplayTrace trace = FlowReplayTraceMapHolder.getAndRemove(traceId);
            if (trace != null) {
                // 创建回放trace上下文
                ReplayTraceContext.create(trace);
            }
        }

        try {
            chain.doFilter(request, response);
        } finally {
            ReplayTraceContext context = ReplayTraceContext.getAndRemove();
            if (context != null) {
                ReplayTraceContextMapHolder.put(context);
            }
        }
    }

    @Override
    public void destroy() {
        // do nothing
    }
}
