package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * contextMap用于存放回放的上下文，便于给后续replayer根据traceId获取到，做报告的构建
 * Created by guoyanfei .
 * 2019-03-15 .
 */
public class ReplayTraceContextMapHolder {

    /**
     * key: traceId
     * value: ReplayTraceContextHolder
     */
    private static Map<String, ReplayTraceContextBlockingWrapper> contextMap = new ConcurrentHashMap<>();

    /**
     * 预先占坑
     * @param traceId
     */
    public static void preset(String traceId) {
        contextMap.putIfAbsent(traceId, new ReplayTraceContextBlockingWrapper());
    }

    /**
     * 获取ReplayTraceContext并且删除
     * get()方法会阻塞，直到set()方法被执行
     * @param traceId
     * @return
     */
    public static ReplayTraceContext getAndRemove(String traceId) {
        ReplayTraceContextBlockingWrapper context0 = contextMap.get(traceId);
        if (context0 == null) {
            return null;
        }
        ReplayTraceContext context = context0.get();
        contextMap.remove(traceId);
        return context;
    }

    /**
     * 设置ReplayTraceContext
     * @param replayTraceContext
     */
    public static void put(ReplayTraceContext replayTraceContext) {
        ReplayTraceContextBlockingWrapper context = contextMap.get(replayTraceContext.getTraceId());
        if (context == null) {
            return;
        }
        context.set(replayTraceContext);
    }

    private static class ReplayTraceContextBlockingWrapper {

        private ReplayTraceContext replayTraceContext;

        /**
         * 标识replayTraceContext是否已经被set
         */
        private boolean filled = false;

        public synchronized void set(ReplayTraceContext replayTraceContext) {
            if (filled) {
                return;
            }
            this.replayTraceContext = replayTraceContext;
            filled = true;  // 标识已经设置了 replayTraceContext
            this.notifyAll();
        }

        public synchronized ReplayTraceContext get() {
            while (!filled) {
                try {
                    this.wait();
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.replayTraceContext;
        }

    }

}
