package cn.com.duibaboot.ext.autoconfigure.gclog;

import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * gc日志相关的endpoint的自动配置
 * Created by guoyanfei .
 */
@Configuration
public class GclogAutoConfiguration {

    @Bean
    @ConditionalOnEnabledEndpoint("gclogDownload")
    public GclogDownloadMvcEndpoint gclogDownloadMvcEndpoint() {
        return new GclogDownloadMvcEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public GclogEndpoint gclogEndpoint() {
        return new GclogEndpoint();
    }
}
