/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import com.google.common.collect.ImmutableSet;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.hadoop.hbase.client.Table;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

@Aspect
public class SleuthHbasePlugin {
    private static final String space = "Hbase";
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;
    private static final ImmutableSet<String> BLACK_METHODS = ImmutableSet.of((Object)"toString", (Object)"hashCode", (Object)"equals", (Object)"getClass", (Object)"wait", (Object)"notify", (Object[])new String[]{"notifyAll"});
    private static final ImmutableSet<String> WHITE_METHODS = ImmutableSet.of((Object)"exists", (Object)"existsAll", (Object)"batch", (Object)"batchCallback", (Object)"get", (Object)"getScanner", (Object[])new String[]{"put", "checkAndPut", "delete", "checkAndDelete", "mutateRow", "append", "increment", "incrementColumnValue"});

    @Around(value="execution(* org.apache.hadoop.hbase.client.HTableInterfaceFactory.createHTableInterface(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Table htable = (Table)joinPoint.proceed();
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget((Object)htable);
        factory.addAdvice((Advice)new HbaseMethodInterceptor());
        return factory.getProxy();
    }

    public class HbaseMethodInterceptor
    implements MethodInterceptor {
        HbaseMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (BLACK_METHODS.contains((Object)methodName) || !WHITE_METHODS.contains((Object)methodName)) {
                return invocation.proceed();
            }
            if (!SleuthHbasePlugin.this.tracer.isTracing() || !SleuthHbasePlugin.this.tracer.getCurrentSpan().isExportable()) {
                return invocation.proceed();
            }
            Class<?> clazz = invocation.getThis().getClass();
            Span span = SleuthHbasePlugin.this.tracer.createSpan("Hbase:/" + methodName);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(clazz.getSimpleName()).append(".").append(methodName);
            try {
                span.tag("Hbase.class_method", stringBuilder.toString());
                span.tag("lc", SleuthHbasePlugin.space);
                span.tag("peer.service", SleuthHbasePlugin.space);
                span.logEvent("cs");
                Object object = invocation.proceed();
                return object;
            }
            catch (Exception e) {
                SleuthHbasePlugin.this.errorParser.parseErrorTags(span, (Throwable)e);
                throw e;
            }
            finally {
                span.logEvent("cr");
                SleuthHbasePlugin.this.tracer.close(span);
            }
        }
    }
}

