/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.core.utils.SpringBootUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootVersion;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class CommonDiscoveryMetadataRegister
implements DiscoveryMetadataRegister {
    private static long serverStartUpTime;
    @Value(value="${run.in.docker:false}")
    private boolean runInDocker;
    @Value(value="${duiba.perf.scene.id:}")
    private String duibaPerfSceneId;
    @Value(value="${duiba.service.group.key:}")
    private String duibaServiceGroupKey;
    @Value(value="${duiba.warmup.timemillis:300000}")
    private Integer duibaWarmUpTimeMillis;
    @Autowired
    private Environment environment;

    private synchronized long getServerStartUpTime() {
        if (serverStartUpTime == 0L) {
            serverStartUpTime = System.currentTimeMillis();
        }
        return serverStartUpTime;
    }

    @Override
    public void registerMetadata(Map<String, String> metadata) {
        long serverStartUpTime = this.getServerStartUpTime();
        metadata.put("serverStartUpTime", String.valueOf(serverStartUpTime));
        metadata.put("duiba.warmup.timemillis", String.valueOf(this.duibaWarmUpTimeMillis));
        metadata.put("weight", String.valueOf(100));
        metadata.put("runInSingleJarMode", SpringBootUtils.isJarInJarMode() ? "true" : "false");
        metadata.put("springBootVersion", StringUtils.trimToEmpty((String)SpringBootVersion.getVersion()));
        metadata.put("duibaBootVersion", StringUtils.trimToEmpty((String)DuibaBootVersion.getVersion()));
        metadata.put("run.in.docker", this.runInDocker ? "true" : "false");
        if (!StringUtils.isBlank((CharSequence)this.duibaPerfSceneId)) {
            metadata.put("duiba.perf.scene.id", this.duibaPerfSceneId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.duibaServiceGroupKey)) {
            metadata.put("duiba.service.group.key", this.duibaServiceGroupKey);
        }
        metadata.put("configVersion", StringUtils.trimToEmpty((String)this.environment.getProperty("config.client.version")));
    }
}

