/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.reflect.MethodSignature;

public final class FlowReplayUtils {
    private FlowReplayUtils() {
    }

    public static boolean isJSONValid(String json) {
        try {
            JSONObject.parseObject((String)json);
        }
        catch (Exception e0) {
            try {
                JSONObject.parseArray((String)json);
            }
            catch (Exception e1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isReplayEnv() {
        String duibaFlowReplayReportId = System.getenv("DUIBA_FLOW_REPLAY_REPORT_ID");
        return StringUtils.isNotBlank((CharSequence)duibaFlowReplayReportId);
    }

    public static String parseApiNameByMethod(Method method) {
        StringBuilder sb = new StringBuilder();
        FlowReplayUtils.appendType(sb, method.getDeclaringClass());
        sb.append(".");
        sb.append(method.getName());
        sb.append("(");
        Class<?>[] parametersTypes = method.getParameterTypes();
        FlowReplayUtils.appendTypes(sb, parametersTypes);
        sb.append(")");
        return sb.toString();
    }

    public static boolean isMethodEqual(String spanMethod, Method currentMethod) {
        return spanMethod.equals(currentMethod.getName());
    }

    public static boolean isArgumentsTypesEqual(String[] spanParameterTypes, Class<?>[] currentParameterTypes) {
        for (int i = 0; i < currentParameterTypes.length; ++i) {
            if (currentParameterTypes[i].getName().equals(spanParameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static String stringArrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        return Joiner.on((String)",").join((Object[])stringArray);
    }

    public static String classArrayToString(Class<?>[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return "";
        }
        ArrayList<String> classNames = new ArrayList<String>(classArray.length);
        for (Class<?> c : classArray) {
            classNames.add(c.getName());
        }
        return Joiner.on((String)",").join(classNames);
    }

    public static boolean isArgumentsEqual(Object[] spanParameterValues, Object[] currentParameterValues) {
        for (int i = 0; i < currentParameterValues.length; ++i) {
            Object arg = currentParameterValues[i];
            Object spanArg = spanParameterValues[i];
            if (!(arg instanceof byte[] ? !Arrays.equals((byte[])arg, (byte[])spanArg) : !arg.equals(spanArg))) continue;
            return false;
        }
        return true;
    }

    public static boolean isGlobalWhitelist(Object[] allArguments) {
        if (allArguments != null) {
            for (Object obj : allArguments) {
                if (!FlowReplayConstants.CANNOT_DESERIALIZE_CLASSES.contains(obj.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isGuavaWhitelist(String className) {
        return FlowReplayConstants.GUAVA_WHITELIST.contains(className);
    }

    public static boolean isCaffeineWhitelist(String className) {
        return FlowReplayConstants.CAFFEINE_WHITELIST.contains(className);
    }

    public static String parseApiNameByMethodSignature(MethodSignature methodSignature) {
        StringBuilder sb = new StringBuilder();
        FlowReplayUtils.appendType(sb, methodSignature.getDeclaringType());
        sb.append(".");
        sb.append(methodSignature.getMethod().getName());
        sb.append("(");
        Class[] parametersTypes = methodSignature.getParameterTypes();
        FlowReplayUtils.appendTypes(sb, parametersTypes);
        sb.append(")");
        return sb.toString();
    }

    private static void appendTypes(StringBuilder sb, Class<?>[] types) {
        int size = types.length;
        for (int i = 0; i < size; ++i) {
            FlowReplayUtils.appendType(sb, types[i]);
            if (i >= size - 1) continue;
            sb.append(",");
        }
    }

    private static void appendType(StringBuilder sb, Class<?> type) {
        if (type.isArray()) {
            FlowReplayUtils.appendType(sb, type.getComponentType());
            sb.append("[]");
        } else {
            sb.append(type.getSimpleName());
        }
    }
}

