/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordStartEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class RecordTraceWriter {
    private static final Logger log = LoggerFactory.getLogger(RecordTraceWriter.class);

    @EventListener(value={RecordStartEvent.class})
    public void recordStartEventListener(RecordStartEvent event) {
        new Thread(new TraceWriteThread(RecordContextHolder.getRecordContext())).start();
    }

    private class TraceWriteThread
    implements Runnable {
        private RecordContext context;

        private TraceWriteThread(RecordContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.writeTrace();
            }
            catch (Exception e) {
                log.error("writeTrace\u5f02\u5e38", (Throwable)e);
                RecordContextHolder.abnormalEnd("writeTrace\u5f02\u5e38:" + e.getMessage());
            }
        }

        private void writeTrace() throws InterruptedException {
            while (!this.context.isRecordFinished()) {
                if (this.context.isTimeToEnd()) {
                    RecordContextHolder.normalEnd();
                    continue;
                }
                FlowReplayTrace trace = this.context.pollTrace();
                if (trace == null) continue;
                try {
                    this.context.writeTrace(trace);
                    if (!this.context.isFileSizeToEnd()) continue;
                    RecordContextHolder.normalEnd();
                }
                catch (Exception e) {
                    log.error("\u5355\u4e2a\u7528\u4f8b\u5199\u5165\u5f02\u5e38_traceId=" + trace.getTraceId(), (Throwable)e);
                }
            }
        }
    }
}

