/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayConfigDto;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class ReplayContext {
    private static final int TRACE_QUEUE_SIZE = 500;
    private static final int RESULT_QUEUE_SIZE = 500;
    private final Long reportId;
    private final String usecaseSetUrl;
    private volatile Long startTime;
    private volatile Long endTime;
    private LinkedBlockingQueue<FlowReplayTrace> traceQueue;
    private volatile boolean tracesLoadFinished;
    private LinkedBlockingQueue<ReplayTraceResult> resultQueue;
    private volatile boolean replayersDone;
    private volatile ReplayResult replayResult;

    public ReplayContext(ReplayConfigDto replayConfig) {
        this.reportId = replayConfig.getReportId();
        this.usecaseSetUrl = replayConfig.getUsecaseSetUrl();
        this.traceQueue = new LinkedBlockingQueue(500);
        this.resultQueue = new LinkedBlockingQueue(500);
        this.tracesLoadFinished = false;
        this.replayersDone = false;
        this.startTime = null;
        this.endTime = null;
        this.replayResult = null;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
    }

    public void offerTrace(FlowReplayTrace trace) {
        this.traceQueue.offer(trace);
    }

    public FlowReplayTrace pollTrace() throws InterruptedException {
        return this.traceQueue.poll(2L, TimeUnit.SECONDS);
    }

    public boolean isTraceQueueEmpty() {
        return this.traceQueue.size() < 1;
    }

    public void tracesLoadFinish() {
        this.tracesLoadFinished = true;
    }

    public boolean isTracesLoadFinished() {
        return this.tracesLoadFinished;
    }

    public void offerResult(ReplayTraceResult result) {
        this.resultQueue.offer(result);
    }

    public ReplayTraceResult pollResult() throws InterruptedException {
        return this.resultQueue.poll(2L, TimeUnit.SECONDS);
    }

    public boolean isResultQueueEmpty() {
        return this.resultQueue.size() < 1;
    }

    public void replayersDone() {
        this.replayersDone = true;
    }

    public boolean isReplayersDone() {
        return this.replayersDone;
    }

    public Long getReportId() {
        return this.reportId;
    }

    public String getUsecaseSetUrl() {
        return this.usecaseSetUrl;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public ReplayResult getReplayResult() {
        return this.replayResult;
    }

    public void setReplayResult(ReplayResult replayResult) {
        this.replayResult = replayResult;
    }
}

