/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.CaffeineCacheFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.KryoException;

public class ReplayCaffeineCacheMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReplayCaffeineCacheMethodInterceptor.class);

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (!FlowReplayConstants.CAFFEINE_CACHE_AOP_METHOD.contains(method.getName())) {
            return;
        }
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return;
        }
        if (FlowReplayUtils.isGlobalWhitelist(allArguments) || FlowReplayUtils.isCaffeineWhitelist(obj.getClass().getName())) {
            return;
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        log.debug("Caffeine_Cache_poll_span_TraceId_{}_spanType_{}", (Object)ReplayTraceContext.getContextTraceId(), (Object)(span != null ? span.getSpanType() : null));
        if (span == null || SpanType.CAFFEINE_CACHE != span.getSpanType()) {
            String expert = SpanType.CAFFEINE_CACHE.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            return;
        }
        CaffeineCacheFlowReplaySpan caffeineSpan = (CaffeineCacheFlowReplaySpan)span;
        if (!FlowReplayUtils.isMethodEqual(caffeineSpan.getMethodName(), method)) {
            String expert = caffeineSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_502, expert, actual);
            return;
        }
        if (!FlowReplayUtils.isArgumentsTypesEqual(caffeineSpan.getParameterTypes(), argumentsTypes)) {
            String expert = FlowReplayUtils.stringArrayToString(caffeineSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(argumentsTypes);
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_500, expert, actual);
            return;
        }
        try {
            if (!FlowReplayUtils.isArgumentsEqual(caffeineSpan.getParameterValues(), allArguments)) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_501);
                return;
            }
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_503, e.getMessage());
            return;
        }
        try {
            result.defineReturnValue(caffeineSpan.getReturnValue());
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_504, e.getMessage());
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

