/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.nustaq.serialization;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import shaded.org.nustaq.serialization.FSTClazzInfo;
import shaded.org.nustaq.serialization.FSTConfiguration;
import shaded.org.nustaq.serialization.FSTSerializerRegistry;
import shaded.org.nustaq.serialization.FSTSerializerRegistryDelegate;
import shaded.org.nustaq.serialization.util.FSTMap;

public class FSTClazzInfoRegistry {
    FSTMap mInfos = new FSTMap(97);
    FSTSerializerRegistry serializerRegistry = new FSTSerializerRegistry();
    boolean ignoreAnnotations = false;
    final AtomicBoolean rwLock = new AtomicBoolean(false);
    private boolean structMode = false;

    public static void addAllReferencedClasses(Class cl, ArrayList<String> names, String filter2) {
        HashSet<String> names1 = new HashSet<String>();
        FSTClazzInfoRegistry.addAllReferencedClasses(cl, names1, new HashSet<String>(), filter2);
        names.addAll(names1);
    }

    static void addAllReferencedClasses(Class cl, HashSet<String> names, HashSet<String> topLevelDone, String filter2) {
        if (cl == null || topLevelDone.contains(cl.getName()) || !cl.getName().startsWith(filter2)) {
            return;
        }
        topLevelDone.add(cl.getName());
        Field[] declaredFields = cl.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            Field declaredField = declaredFields[i];
            Class<?> type = declaredField.getType();
            if (type.isPrimitive() || type.isArray()) continue;
            names.add(type.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(type, names, topLevelDone, filter2);
        }
        Class<?>[] declaredClasses = cl.getDeclaredClasses();
        for (int i = 0; i < declaredClasses.length; ++i) {
            Class<?> declaredClass = declaredClasses[i];
            if (declaredClass.isPrimitive() || declaredClass.isArray()) continue;
            names.add(declaredClass.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(declaredClass, names, topLevelDone, filter2);
        }
        Method[] declaredMethods = cl.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            Class<?> returnType = declaredMethod.getReturnType();
            if (!returnType.isPrimitive() && !returnType.isArray()) {
                names.add(returnType.getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(returnType, names, topLevelDone, filter2);
            }
            Class<?>[] parameterTypes = declaredMethod.getParameterTypes();
            for (int j = 0; j < parameterTypes.length; ++j) {
                Class<?> parameterType = parameterTypes[j];
                if (parameterType.isPrimitive() || parameterType.isArray()) continue;
                names.add(parameterType.getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(parameterType, names, topLevelDone, filter2);
            }
        }
        Class<?>[] classes = cl.getDeclaredClasses();
        for (int i = 0; i < classes.length; ++i) {
            Class<?> aClass = classes[i];
            if (aClass.isPrimitive() || aClass.isArray()) continue;
            names.add(aClass.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(aClass, names, topLevelDone, filter2);
        }
        Class<?> enclosingClass = cl.getEnclosingClass();
        if (enclosingClass != null) {
            names.add(enclosingClass.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(enclosingClass, names, topLevelDone, filter2);
        }
        names.add(cl.getName());
        FSTClazzInfoRegistry.addAllReferencedClasses(cl.getSuperclass(), names, topLevelDone, filter2);
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (anInterface.isPrimitive() || anInterface.isArray()) continue;
            names.add(anInterface.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(anInterface, names, topLevelDone, filter2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSTClazzInfo getCLInfo(Class c, FSTConfiguration conf) {
        while (!this.rwLock.compareAndSet(false, true)) {
        }
        try {
            FSTClazzInfo res = (FSTClazzInfo)this.mInfos.get(c);
            if (res == null) {
                if (c == null) {
                    throw new NullPointerException("Class is null");
                }
                if (conf.getVerifier() != null && !conf.getVerifier().allowClassDeserialization(c)) {
                    throw new RuntimeException("tried to deserialize forbidden class " + c.getName());
                }
                res = new FSTClazzInfo(conf, c, this, this.ignoreAnnotations);
                this.mInfos.put(c, res);
            }
            FSTClazzInfo fSTClazzInfo = res;
            return fSTClazzInfo;
        }
        finally {
            this.rwLock.set(false);
        }
    }

    public FSTSerializerRegistry getSerializerRegistry() {
        return this.serializerRegistry;
    }

    public final boolean isIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    public void setSerializerRegistryDelegate(FSTSerializerRegistryDelegate delegate) {
        this.serializerRegistry.setDelegate(delegate);
    }

    public FSTSerializerRegistryDelegate getSerializerRegistryDelegate() {
        return this.serializerRegistry.getDelegate();
    }

    public void setStructMode(boolean structMode) {
        this.structMode = structMode;
    }

    public boolean isStructMode() {
        return this.structMode;
    }
}

