/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duibaboot.ext.autoconfigure.data.hbase.HTableConnectionFactory;
import cn.com.duibaboot.ext.autoconfigure.data.hbase.HbaseProperties;
import cn.com.duibaboot.ext.autoconfigure.data.hbase.WrappedHbaseTemplate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class ExtraHbaseImportBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private List<String> extraHbaseTemplateIds = new ArrayList<String>();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        for (String extraHbaseTemplateId : this.extraHbaseTemplateIds) {
            AbstractBeanDefinition extraHbaseTemplateDefinition = BeanDefinitionBuilder.genericBeanDefinition(WrappedHbaseTemplateFactoryBean.class).addConstructorArgValue((Object)extraHbaseTemplateId).getBeanDefinition();
            registry.registerBeanDefinition(extraHbaseTemplateId, (BeanDefinition)extraHbaseTemplateDefinition);
        }
    }

    public void setEnvironment(Environment environment) {
        String hbaseExtraIdPrefix = "duiba.hbase.extra.";
        String hbaseExtraIdPostfix = ".zk-quorum";
        LinkedHashMap props = SpringEnvironmentUtils.getFlatEnvironments((Environment)environment);
        props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(hbaseExtraIdPrefix) && ((String)e.getKey()).endsWith(hbaseExtraIdPostfix)).map(e -> ((String)e.getKey()).substring(hbaseExtraIdPrefix.length(), ((String)e.getKey()).length() - hbaseExtraIdPostfix.length())).forEach(s -> this.extraHbaseTemplateIds.add((String)s));
    }

    public static class WrappedHbaseTemplateFactoryBean
    implements FactoryBean<WrappedHbaseTemplate> {
        @Resource
        private HbaseProperties hbaseProperties;
        private String extraKey;

        public WrappedHbaseTemplateFactoryBean(String extraKey) {
            this.extraKey = extraKey;
        }

        public WrappedHbaseTemplate getObject() throws Exception {
            Configuration extraHbaseTemplateConfiguration = this.hbaseProperties.getExtra().get(this.extraKey).getConfiguration();
            HTableConnectionFactory extraHTableInterfaceFactory = new HTableConnectionFactory(extraHbaseTemplateConfiguration);
            WrappedHbaseTemplate extraHbaseTemplate = new WrappedHbaseTemplate(extraHbaseTemplateConfiguration);
            extraHbaseTemplate.setTableFactory(extraHTableInterfaceFactory);
            return extraHbaseTemplate;
        }

        public Class<WrappedHbaseTemplate> getObjectType() {
            return WrappedHbaseTemplate.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

