/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.devtools;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.devtools.BootDevToolsFilter;
import cn.com.duibaboot.ext.autoconfigure.devtools.ClassPathChangedFilesContainer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.devtools.classpath.ClassPathFileSystemWatcher;
import org.springframework.boot.devtools.classpath.PatternClassPathRestartStrategy;
import org.springframework.boot.devtools.filewatch.ChangedFile;
import org.springframework.boot.devtools.restart.ConditionalOnInitializedRestarter;
import org.springframework.boot.devtools.restart.classloader.RestartClassLoader;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
@ConditionalOnWebApplication
public class DevToolsAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
    @ConditionalOnWebApplication
    public static class BootDevToolsFilterConfiguration {
        @Resource
        private ApplicationContext applicationContext;
        @Autowired(required=false)
        private ClassPathChangedFilesContainer classPathChangedFilesContainer;

        @Bean
        public FilterRegistrationBean bootDevToolsFilterConfigurer() {
            BootDevToolsFilter filter2 = new BootDevToolsFilter(this.applicationContext, this.classPathChangedFilesContainer);
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter2);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/devtools/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-2147483647);
            return registrationBean;
        }
    }

    @ConditionalOnClass(value={RestartClassLoader.class})
    @ConditionalOnInitializedRestarter
    @ConditionalOnProperty(prefix="spring.devtools.restart", name={"enabled"}, matchIfMissing=true)
    static class DuibaDevToolsRestartConfiguration {
        DuibaDevToolsRestartConfiguration() {
        }

        @Bean
        public static SpecifiedBeanPostProcessor classPathRestartStrategyPostProcessor() {
            return new SpecifiedBeanPostProcessor<ClassPathFileSystemWatcher>(){

                public int getOrder() {
                    return 0;
                }

                @Override
                public Class<ClassPathFileSystemWatcher> getBeanType() {
                    return ClassPathFileSystemWatcher.class;
                }

                @Override
                public Object postProcessBeforeInitialization(ClassPathFileSystemWatcher bean, String beanName) throws BeansException {
                    Field field = ReflectionUtils.findField(bean.getClass(), (String)"restartStrategy");
                    field.setAccessible(true);
                    String[] excludes = new String[]{"/**"};
                    PatternClassPathRestartStrategy s = new PatternClassPathRestartStrategy(excludes){

                        public boolean isRestartRequired(ChangedFile file) {
                            return false;
                        }
                    };
                    ReflectionUtils.setField((Field)field, (Object)bean, (Object)s);
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(ClassPathFileSystemWatcher bean, String beanName) throws BeansException {
                    return bean;
                }
            };
        }

        @Bean
        public ClassPathChangedFilesContainer classPathChangedFilesContainer(ApplicationContext applicationContext) {
            return new ClassPathChangedFilesContainer(applicationContext);
        }
    }
}

