/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordResultBuilder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordTraceWriter;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.RecordExcludeHandlerInterceptor;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.RecordRemoteServicePlugin;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.RecordSpringMvcFilter;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordResultMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordStopMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.PercentageBasedRecordSampler;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.RecordSampler;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.RecordSamplerProperties;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayResultBuilder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceLoader;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceReplayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResultWriter;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop.ReplaySpringMvcFilter;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayResultMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayStopMvcEndpoint;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.ConcreateReplayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.RemoteServiceReplayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.Replayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.SpringMvcReplayer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.http.client.HttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Lazy
@Configuration
public class FlowReplayAutoConfiguration {
    @Bean
    public FlowReplayFileComponent flowReplayFileComponent(HttpClient httpClient, List<RestTemplateCustomizer> customizers) {
        RestTemplate loadBalancedRestTemplate = this.loadBalancedRestTemplate(httpClient);
        for (RestTemplateCustomizer customizer : customizers) {
            customizer.customize(loadBalancedRestTemplate);
        }
        return new FlowReplayFileComponent(loadBalancedRestTemplate);
    }

    private RestTemplate loadBalancedRestTemplate(HttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(3000);
        httpRequestFactory.setConnectTimeout(3000);
        httpRequestFactory.setReadTimeout(60000);
        httpRequestFactory.setHttpClient(httpClient);
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
        template.getMessageConverters().add(new ByteArrayHttpMessageConverter());
        return template;
    }

    private static class ReplayCondition
    implements Condition {
        private ReplayCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return FlowReplayUtils.isReplayEnv();
        }
    }

    @Configuration
    @Conditional(value={ReplayCondition.class})
    static class ReplayConfiguration {
        ReplayConfiguration() {
        }

        @Bean
        public ReplayMvcEndpoint replayMvcEndpoint() {
            return new ReplayMvcEndpoint();
        }

        @Bean
        public ReplayStopMvcEndpoint replayStopMvcEndpoint() {
            return new ReplayStopMvcEndpoint();
        }

        @Bean
        public ReplayResultMvcEndpoint replayResultMvcEndpoint() {
            return new ReplayResultMvcEndpoint();
        }

        @Bean
        public ReplayTraceLoader replayTraceLoader() {
            return new ReplayTraceLoader();
        }

        @Bean
        public ReplayTraceReplayer replayTraceReplayer() {
            return new ReplayTraceReplayer();
        }

        @Bean
        public ReplayTraceResultWriter replayTraceResultWriter() {
            return new ReplayTraceResultWriter();
        }

        @Bean
        public ReplayResultBuilder replayResultBuilder() {
            return new ReplayResultBuilder();
        }

        @Bean
        public ReplaySpringMvcFilter replaySpringMvcFilter() {
            return new ReplaySpringMvcFilter();
        }

        @Bean
        public FilterRegistrationBean replaySpringMvcFilterConfigurer(ReplaySpringMvcFilter replaySpringMvcFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)replaySpringMvcFilter);
            ArrayList urlPatterns = Lists.newArrayList();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns((Collection)urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(0);
            return registrationBean;
        }

        @Configuration
        static class ReplayerConfiguration {
            ReplayerConfiguration() {
            }

            @Bean
            public RemoteServiceReplayer remoteServiceReplayer() {
                return new RemoteServiceReplayer();
            }

            @Bean
            public SpringMvcReplayer springMvcReplayer() {
                return new SpringMvcReplayer();
            }

            @Bean
            public Replayer replayer() {
                return new ConcreateReplayer();
            }
        }
    }

    @Configuration
    static class RecordConfiguration {
        RecordConfiguration() {
        }

        @Bean
        public RecordMvcEndpoint recordMvcEndpoint() {
            return new RecordMvcEndpoint();
        }

        @Bean
        public RecordStopMvcEndpoint recordStopMvcEndpoint() {
            return new RecordStopMvcEndpoint();
        }

        @Bean
        public RecordResultMvcEndpoint recordResultMvcEndpoint() {
            return new RecordResultMvcEndpoint();
        }

        @Bean
        public RecordResultBuilder recordResultBuilder() {
            return new RecordResultBuilder();
        }

        @Bean
        public RecordSpringMvcFilter recordSpringMvcFilter() {
            return new RecordSpringMvcFilter();
        }

        @Bean
        public RecordTraceWriter recordTraceWriter() {
            return new RecordTraceWriter();
        }

        @Bean
        public FilterRegistrationBean recordSpringMvcFilterConfigurer(RecordSpringMvcFilter recordSpringMvcFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)recordSpringMvcFilter);
            ArrayList urlPatterns = Lists.newArrayList();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns((Collection)urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(0);
            return registrationBean;
        }

        @Configuration
        @ConditionalOnMissingClass(value={"org.springframework.cloud.context.config.annotation.RefreshScope"})
        @EnableConfigurationProperties(value={RecordSamplerProperties.class})
        static class NonRefreshScopedSamplerConfiguration {
            NonRefreshScopedSamplerConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            public RecordSampler recordSampler(RecordSamplerProperties recordSamplerProperties) {
                return new PercentageBasedRecordSampler(recordSamplerProperties);
            }
        }

        @Configuration
        @ConditionalOnClass(value={RefreshScope.class})
        @EnableConfigurationProperties(value={RecordSamplerProperties.class})
        static class RefreshScopedSamplerConfiguration {
            RefreshScopedSamplerConfiguration() {
            }

            @Bean
            @RefreshScope
            @ConditionalOnMissingBean
            public RecordSampler recordSampler(RecordSamplerProperties recordSamplerProperties) {
                return new PercentageBasedRecordSampler(recordSamplerProperties);
            }
        }

        @Configuration
        static class FlowRecordAspectConfiguration {
            FlowRecordAspectConfiguration() {
            }

            @Bean
            public RecordRemoteServicePlugin recordRemoteServicePlugin() {
                return new RecordRemoteServicePlugin();
            }
        }

        @Configuration
        @ConditionalOnClass(value={Servlet.class, RecordExcludeHandlerInterceptor.class, InterceptorRegistry.class})
        @ConditionalOnWebApplication
        @Order(value=-100)
        public static class RecordExcludeHandlerInterceptorConfiguration
        extends WebMvcConfigurerAdapter {
            public void addInterceptors(InterceptorRegistry registry) {
                RecordExcludeHandlerInterceptor interceptor = new RecordExcludeHandlerInterceptor();
                registry.addInterceptor((HandlerInterceptor)interceptor);
                super.addInterceptors(registry);
            }
        }
    }
}

