/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.reflect.MethodSignature;

public final class FlowReplayUtils {
    private FlowReplayUtils() {
    }

    public static boolean isJSONValid(String json) {
        if (json == null) {
            return false;
        }
        if (!json.startsWith("{") && !json.startsWith("[")) {
            return false;
        }
        try {
            JSONObject.parseObject((String)json);
        }
        catch (Exception e0) {
            try {
                JSONObject.parseArray((String)json);
            }
            catch (Exception e1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isReplayEnv() {
        String duibaFlowReplayReportId = System.getenv("DUIBA_FLOW_REPLAY_REPORT_ID");
        return StringUtils.isNotBlank((CharSequence)duibaFlowReplayReportId);
    }

    public static boolean isReportIdValid(Long reportId) {
        String duibaFlowReplayReportId = System.getenv("DUIBA_FLOW_REPLAY_REPORT_ID");
        if (StringUtils.isBlank((CharSequence)duibaFlowReplayReportId)) {
            return false;
        }
        return duibaFlowReplayReportId.equals(String.valueOf(reportId));
    }

    public static String parseApiNameByMethod(Method method) {
        StringBuilder sb = new StringBuilder();
        FlowReplayUtils.appendType(sb, method.getDeclaringClass());
        sb.append(".");
        sb.append(method.getName());
        sb.append("(");
        Class<?>[] parametersTypes = method.getParameterTypes();
        FlowReplayUtils.appendTypes(sb, parametersTypes);
        sb.append(")");
        return sb.toString();
    }

    public static boolean isMethodEqual(String spanMethod, Method currentMethod) {
        return spanMethod.equals(currentMethod.getName());
    }

    public static boolean isArgumentsTypesEqual(String[] spanParameterTypes, Class<?>[] currentParameterTypes) {
        for (int i = 0; i < currentParameterTypes.length; ++i) {
            if (currentParameterTypes[i].getName().equals(spanParameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static String stringArrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        return Joiner.on((String)",").join((Object[])stringArray);
    }

    public static String classArrayToString(Class<?>[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return "";
        }
        ArrayList<String> classNames = new ArrayList<String>(classArray.length);
        for (Class<?> c : classArray) {
            classNames.add(c.getName());
        }
        return Joiner.on((String)",").join(classNames);
    }

    public static boolean isArgumentsEqual(Object[] spanParameterValues, Object[] currentParameterValues) {
        for (int i = 0; i < currentParameterValues.length; ++i) {
            Object arg = currentParameterValues[i];
            Object spanArg = spanParameterValues[i];
            if (FlowReplayUtils.isObjectEqual(JSON.toJSON((Object)spanArg), JSON.toJSON((Object)arg))) continue;
            return false;
        }
        return true;
    }

    public static boolean isGlobalWhitelist(Object[] allArguments) {
        if (allArguments != null) {
            for (Object obj : allArguments) {
                if (obj == null || !FlowReplayConstants.CANNOT_DESERIALIZE_CLASSES.contains(obj.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isObjectEqual(Object recordVal, Object replayVal) {
        if (recordVal == null && replayVal == null) {
            return true;
        }
        if (recordVal instanceof byte[] && replayVal instanceof byte[]) {
            return Arrays.equals((byte[])recordVal, (byte[])replayVal);
        }
        if (recordVal instanceof String && replayVal instanceof String) {
            return recordVal.equals(replayVal);
        }
        if (recordVal instanceof JSONArray && replayVal instanceof JSONArray) {
            return FlowReplayUtils.isJSONArrayEqual((JSONArray)recordVal, (JSONArray)replayVal);
        }
        if (recordVal instanceof JSONObject && replayVal instanceof JSONObject) {
            return FlowReplayUtils.isJSONObjectEqual((JSONObject)recordVal, (JSONObject)replayVal);
        }
        if (recordVal != null) {
            return recordVal.equals(replayVal);
        }
        return false;
    }

    private static boolean isJSONArrayEqual(JSONArray recordArray, JSONArray replayArray) {
        if (recordArray.size() != replayArray.size()) {
            return false;
        }
        Iterator iterator = recordArray.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Object recordValue = iterator.next();
            String recordValueStr = String.valueOf(recordValue);
            if (FlowReplayUtils.isJSONValid(recordValueStr)) {
                return FlowReplayUtils.isObjectEqual(JSON.parse((String)recordValueStr), JSON.parse((String)String.valueOf(recordArray.get(i))));
            }
            if (!Objects.equals(recordValue, replayArray.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isJSONObjectEqual(JSONObject recordObj, JSONObject replayObj) {
        for (Map.Entry entry : recordObj.entrySet()) {
            Object recordValue = entry.getValue();
            Object replayValue = replayObj.get(entry.getKey());
            String recordValueStr = String.valueOf(recordValue);
            String replayValueStr = String.valueOf(replayValue);
            if (FlowReplayUtils.isJSONValid(recordValueStr)) {
                return FlowReplayUtils.isObjectEqual(JSON.parse((String)recordValueStr), JSON.parse((String)replayValueStr));
            }
            if (Objects.equals(recordValue, replayValue)) continue;
            return false;
        }
        return true;
    }

    public static String parseApiNameByMethodSignature(MethodSignature methodSignature) {
        StringBuilder sb = new StringBuilder();
        FlowReplayUtils.appendType(sb, methodSignature.getDeclaringType());
        sb.append(".");
        sb.append(methodSignature.getMethod().getName());
        sb.append("(");
        Class[] parametersTypes = methodSignature.getParameterTypes();
        FlowReplayUtils.appendTypes(sb, parametersTypes);
        sb.append(")");
        return sb.toString();
    }

    private static void appendTypes(StringBuilder sb, Class<?>[] types) {
        int size = types.length;
        for (int i = 0; i < size; ++i) {
            FlowReplayUtils.appendType(sb, types[i]);
            if (i >= size - 1) continue;
            sb.append(",");
        }
    }

    private static void appendType(StringBuilder sb, Class<?> type) {
        if (type.isArray()) {
            FlowReplayUtils.appendType(sb, type.getComponentType());
            sb.append("[]");
        } else {
            sb.append(type.getSimpleName());
        }
    }
}

