/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.RecordSampler;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.RecordSamplerProperties;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class PercentageBasedRecordSampler
implements RecordSampler {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final BitSet sampleDecisions;
    private final RecordSamplerProperties configuration;

    public PercentageBasedRecordSampler(RecordSamplerProperties configuration) {
        int outOf10000 = (int)(configuration.getPercentage() * 10000.0f);
        this.sampleDecisions = PercentageBasedRecordSampler.randomBitSet(10000, outOf10000, new Random());
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSampled() {
        if (this.configuration.getPercentage() == 0.0f) {
            return false;
        }
        if (this.configuration.getPercentage() == 1.0f) {
            return true;
        }
        PercentageBasedRecordSampler percentageBasedRecordSampler = this;
        synchronized (percentageBasedRecordSampler) {
            int i = this.counter.getAndIncrement();
            boolean result = this.sampleDecisions.get(i);
            if (i == 9999) {
                this.counter.set(0);
            }
            return result;
        }
    }

    static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }
}

