package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import cn.com.duibaboot.ext.autoconfigure.core.utils.SpringBootUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootVersion;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import static cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataAutoConfiguration.*;

import java.util.Map;

@Component
public class CommonDiscoveryMetadataRegister implements DiscoveryMetadataRegister {
    //服务器启动时间
    private static long serverStartUpTime;

    @Value("${"+RUN_IN_DOCKER+":false}")
    private boolean runInDocker;//当前服务器是否运行在docker容器中
    @Value("${"+DUIBA_PERF_SCENE_ID+":}")
    private String duibaPerfSceneId;//当前服务器的压测场景ID
    @Value("${"+DUIBA_SERVICE_GROUP_KEY+":}")
    private String duibaServiceGroupKey;//当前服务器的多场景测试的场景ID
    @Value("${"+ DUIBA_WARMUP_TIMEMILLIS +":300000}")
    private Integer duibaWarmUpTimeMillis;

    @Autowired
    private Environment environment;

    /**
     * 获取服务启动时间，确保只生成一次。
     * @return
     */
    private synchronized long getServerStartUpTime(){
        if(serverStartUpTime == 0){
            serverStartUpTime = System.currentTimeMillis();
        }
        return serverStartUpTime;
    }

    @Override
    public void registerMetadata(Map<String, String> metadata) {
        long serverStartUpTime = getServerStartUpTime();

        //metadata中放入服务器启动时间
        metadata.put(SERVER_START_UP_TIME_KEY, String.valueOf(serverStartUpTime));
        metadata.put(DUIBA_WARMUP_TIMEMILLIS, String.valueOf(duibaWarmUpTimeMillis));

        //metadata中放入服务器权重,默认100
        //TODO 这里有点小问题，如果有人改了权重，refresh之后权重会被重置回100,后期改掉,把100作为变量放在某处，允许改变
        metadata.put(WEIGHT_KEY, String.valueOf(100));

        metadata.put(RUN_IN_SINGLE_JAR_MODE, SpringBootUtils.isJarInJarMode() ? "true" : "false");
        metadata.put(SPRING_BOOT_VERSION, StringUtils.trimToEmpty(SpringBootVersion.getVersion()));
        metadata.put(DUIBA_BOOT_VERSION, StringUtils.trimToEmpty(DuibaBootVersion.getVersion()));
        metadata.put(RUN_IN_DOCKER, runInDocker ? "true" : "false");
        if(!StringUtils.isBlank(duibaPerfSceneId)) {
            metadata.put(DUIBA_PERF_SCENE_ID, duibaPerfSceneId);
        }
        if (StringUtils.isNotBlank(duibaServiceGroupKey)) {
            metadata.put(DUIBA_SERVICE_GROUP_KEY, duibaServiceGroupKey);
        }
        metadata.put(CONFIG_VERSION, StringUtils.trimToEmpty(environment.getProperty("config.client.version")));
    }
}
