package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RedisFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;

/**
 * 流量录制的redis方法拦截器
 * 把方法名称，参数列表，参数值列表，都录制下来
 */
@Slf4j
public class RecordJedisMethodInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
        //do nothing
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        if (FlowReplayConstants.REDIS_AOP_EXCLUDE_METHOD.contains(method.getName())) {
            return ret;
        }
        if (!FlowReplayTrace.isTraced()) {
            return ret;
        }
        try {
            if (FlowReplayUtils.isGlobalWhitelist(allArguments)) {
                return ret;
            }
            RedisFlowReplaySpan span = RedisFlowReplaySpan.createSpan(method, allArguments, argumentsTypes, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
        } catch (Throwable t) {
            log.error("Redis_录制异常", t);
        }
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
