/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.annotation.Order;

@Order(value=-2147483642)
public class DuibaTraceSecondFilter
implements Filter {
    private Pattern skipPattern = Pattern.compile("/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream");
    private static Tracer tracer;

    @Autowired
    public void setTracer(Tracer tracer) {
        DuibaTraceSecondFilter.tracer = tracer;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("Filter just supports HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean skip = this.skipPattern.matcher(httpRequest.getRequestURI()).matches();
        if (!skip) {
            Span span = tracer.getCurrentSpan();
            String bagFlages = span.getBaggageItem("X-B3-Flags");
            String flages = (String)Optional.ofNullable(servletRequest.getAttribute("X-B3-Flags")).orElse("0");
            if (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)flages) || StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)bagFlages)) {
                span.setBaggageItem("X-B3-Flags", "1");
                response.setHeader("X-B3-TraceId", span.traceIdString());
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    protected static Boolean isDebugMode() {
        if (tracer == null || !tracer.isTracing()) {
            return false;
        }
        Span span = tracer.getCurrentSpan();
        String bagFlages = span.getBaggageItem("X-B3-Flags");
        return StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)bagFlages);
    }
}

