/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.Hessian2Serializer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ReplayTraceLoader {
    private static final Logger log = LoggerFactory.getLogger(ReplayTraceLoader.class);
    @Resource
    private FlowReplayFileComponent flowReplayFileComponent;

    @EventListener(value={ReplayStartEvent.class})
    public void replayStartEventListener(ReplayStartEvent event) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ReplayContext context = ReplayContextHolder.getReplayContext();
                if (context == null) {
                    return;
                }
                try {
                    ReplayTraceLoader.this.loadUsecaseSet(context);
                }
                catch (IOException e) {
                    log.error("loadUsecaseSet_error", (Throwable)e);
                }
                finally {
                    context.tracesLoadFinish();
                }
            }
        }, "DBThread-Replay-LoadUsecaseSet").start();
    }

    private void loadUsecaseSet(ReplayContext context) throws IOException {
        String localReplayPath = this.flowReplayFileComponent.download(context.getUsecaseSetUrl());
        File file = new File(localReplayPath);
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            raf.skipBytes(8);
            while (raf.getFilePointer() < raf.length()) {
                int length = raf.readInt();
                byte[] traceBytes = new byte[length];
                for (int i = 0; i < length; ++i) {
                    traceBytes[i] = raf.readByte();
                }
                FlowReplayTrace trace = (FlowReplayTrace)Hessian2Serializer.deserialize(traceBytes);
                context.offerTrace(trace);
            }
        }
    }
}

