/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceRunnable;

public class MonitorRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorRunnable.class);
    static final int MAX_WAIT_TIME_MILLIS = 1000;
    private static final boolean IS_SLEUTH_CLASS_EXISTS;
    private Runnable runnable;
    private BlockingQueue<Runnable> queue;
    private final long submitTimeMillis;

    public MonitorRunnable(Runnable runnable) {
        this.runnable = runnable;
        this.submitTimeMillis = System.currentTimeMillis();
    }

    public MonitorRunnable(Runnable runnable, BlockingQueue<Runnable> queue) {
        this(runnable);
        this.queue = queue;
    }

    public long getSubmitTimeMillis() {
        return this.submitTimeMillis;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    public void run() {
        long waitTimeMillis = System.currentTimeMillis() - this.submitTimeMillis;
        if (waitTimeMillis >= 1000L) {
            if (this.queue == null) {
                logger.error("RunnableClass:{}, ThreadName:{} wait {} ms in queue, maybe corePoolSize is too small.", new Object[]{this.getRootRunnable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis});
            } else {
                logger.error("RunnableClass:{}, ThreadName:{} wait {} ms in queue(queueSize:{}), maybe corePoolSize is too small.", new Object[]{this.getRootRunnable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis, this.queue.size()});
            }
        }
        this.runnable.run();
    }

    protected Runnable getRootRunnable() {
        Runnable rootRunnable = this.getRunnable();
        if (IS_SLEUTH_CLASS_EXISTS && rootRunnable instanceof SpanContinuingTraceRunnable) {
            rootRunnable = ((SpanContinuingTraceRunnable)rootRunnable).getDelegate();
        }
        return rootRunnable;
    }

    static {
        boolean isSleuthClassExists = false;
        try {
            Class.forName("org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceRunnable");
            isSleuthClassExists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_SLEUTH_CLASS_EXISTS = isSleuthClassExists;
    }
}

