package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.Hessian2Serializer;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.context.event.EventListener;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * 回放结果写到文件中
 * Created by guoyanfei .
 * 2019-02-26 .
 */
@Slf4j
public class ReplayTraceResultWriter {

    /**
     * 监听 "回放开始" 事件，把回放结果写到文件中
     * @param event
     */
    @EventListener(ReplayStartEvent.class)
    public void replayStartEventListener(ReplayStartEvent event) {
        new Thread(new Runnable() {

            @Override
            public void run() {
                ReplayContext context = ReplayContextHolder.getReplayContext();
                if (context == null) {
                    return;
                }
                try {
                    writeTraceResult(context);
                } catch (Exception e) {
                    log.error("引流回归_回放结果写文件异常_reportId_{}", context.getReportId(), e);
                    ReplayContextHolder.forceEnd();
                }
            }
        }, "DBThread-Replay-写回放结果").start();
    }

    private void writeTraceResult(ReplayContext context) throws IOException, InterruptedException {   // NOSONAR
        File file = new File(FlowReplayConstants.LOCAL_RESULT_FILEPATH);
        RandomAccessFile raf = null;
        try {   // NOSONAR
            while (!context.isReplayersDone() || !context.isResultQueueEmpty()) {
                ReplayTraceResult result = context.pollResult();
                if (result == null) {
                    continue;
                }
                if (raf == null) {
                    raf = new RandomAccessFile(file, "rw");
                    raf.writeInt(FlowReplayConstants.REPLAY_RESULT_FILE_VERSION);  // 回放结果文件版本
                    raf.writeInt(0);    // 文件初始化，结果个数为0
                }
                byte[] resultBytes = Hessian2Serializer.serialize(result);
                raf.writeInt(resultBytes.length);    // 写入单个result的长度，读取的时候先读取长度，然后根据长度，放心读取result
                raf.write(resultBytes);              // 写入result
            }
        } finally {
            IOUtils.closeQuietly(raf);
            // 文件写好，结束回放
            ReplayContextHolder.end();
        }
    }

}
