package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.*;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.esotericsoftware.kryo.KryoException;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;

/**
 * caffeine缓存的方法回放
 * Created by guoyanfei .
 * 2019-04-15 .
 */
@Slf4j
public class ReplayCaffeineCacheMethodInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (!FlowReplayConstants.CAFFEINE_CACHE_AOP_METHOD.contains(method.getName())) {
            return;
        }
        // 当前不是回放的环境 或者 当前请求不是回放请求
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return;
        }

        if (FlowReplayUtils.isGlobalWhitelist(allArguments) || FlowReplayUtils.isCaffeineWhitelist(obj.getClass().getName())) {
            return;
        }

        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();

        log.debug("Caffeine_Cache_poll_span_TraceId_{}_spanType_{}", ReplayTraceContext.getContextTraceId(), span != null ? span.getSpanType() : null);

        // 增加了新的调用 || 调用内容有变动
        if (span == null || SpanType.CAFFEINE_CACHE != span.getSpanType()) {
            String expert = SpanType.CAFFEINE_CACHE.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            return;
        }

        CaffeineCacheFlowReplaySpan caffeineSpan = (CaffeineCacheFlowReplaySpan) span;

        if (!FlowReplayUtils.isMethodEqual(caffeineSpan.getMethodName(), method)) {
            String expert = caffeineSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_502, expert, actual);
            return;
        }

        if (!FlowReplayUtils.isArgumentsTypesEqual(caffeineSpan.getParameterTypes(), argumentsTypes)) {
            String expert = FlowReplayUtils.stringArrayToString(caffeineSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(argumentsTypes);
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_500, expert, actual);
            return;
        }

        try {
            if (!FlowReplayUtils.isArgumentsEqual(caffeineSpan.getParameterValues(), allArguments)) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_501);
                return;
            }
        } catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_503, e.getMessage());
            return;
        }

        try {
            result.defineReturnValue(caffeineSpan.getReturnValue());
        } catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_504, e.getMessage());
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
