package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * 流量回放开始
 * Created by guoyanfei .
 * 2019-02-19 .
 */
public class ReplayMvcEndpoint extends AbstractNamedMvcEndpoint {

    @Resource
    private ApplicationContext applicationContext;

    @Resource
    private FlowReplayFileComponent flowReplayFileComponent;

    public ReplayMvcEndpoint() {
        super("flow/replay", "/flow/replay", true);
    }

    @ResponseBody
    @RequestMapping(method = RequestMethod.POST)
    public String invoke(@RequestBody ReplayConfigDto replayConfig) throws IOException {
        JsonResult<String> result;
        try {
            if (!FlowReplayUtils.isReplayEnv()) {
                throw new FlowReplayException("当前服务非回放专用服务，无法进行回放相关操作");
            }
            if (!FlowReplayUtils.isReportIdValid(replayConfig.getReportId())) {
                throw new FlowReplayException("回放报告ID不合法");
            }
            ReplayContextHolder.start(replayConfig);
            result = JsonResult.successResult("ok");
        } catch (Exception e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }



}
