package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

import java.io.IOException;
import java.util.concurrent.Future;

public class SsreHttpAsyncClientWrapper extends CloseableHttpAsyncClient implements ClientWrapper{

    private CloseableHttpAsyncClient client;

    @Override
    public boolean isRunning() {
        return client.isRunning();
    }

    @Override
    public void start() {
        client.start();
    }

    @Override
    public void close() throws IOException {
        client.close();
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        try {
            SsreUtils.checkSsre(requestProducer.getTarget());
        }catch (SsreRiskException e){
            final BasicFuture<T> future = new BasicFuture<>(callback);
            future.failed(e);
            return future;
        }
        return client.execute(requestProducer,responseConsumer,context,callback);
    }

    @Override
    public boolean trySetClient(Object client) {
        if(client==null || !CloseableHttpAsyncClient.class.isAssignableFrom(client.getClass())){
            return false;
        }
        this.client = (CloseableHttpAsyncClient)client;
        return true;
    }

    @Override
    public Class acceptableClass() {
        return HttpAsyncClient.class;
    }
}
