package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duibaboot.ext.autoconfigure.cat.annotation.CatTransaction;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.*;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.exception.RemotingException;

/**
 * 官方RocketMq发送端的包装类，进行一些增强(只对同步发送的代码进行增强)：<br/>
 * 1.增加cat监控;
 */
public class DefaultMQProducerWrapper extends DefaultMQProducer {

    @Override
    @CatTransaction(type="MessageQueue", name="RocketMQ.send")
    public SendResult send(final Message msg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return super.send(msg);
    }

    @Override
    @CatTransaction(type="MessageQueue", name="RocketMQ.send")
    public SendResult send(Message msg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return super.send(msg, timeout);
    }

    @Override
    @CatTransaction(type="MessageQueue", name="RocketMQ.send")
    public SendResult send(Message msg, MessageQueue mq) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return super.send(msg, mq);
    }

    @Override
    @CatTransaction(type="MessageQueue", name="RocketMQ.send")
    public SendResult send(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return super.send(msg, mq, timeout);
    }

    @Override
    @CatTransaction(type="MessageQueue", name="RocketMQ.send")
    public SendResult send(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return super.send(msg, selector, arg);
    }

    @Override
    @CatTransaction(type="MessageQueue", name="RocketMQ.send")
    public SendResult send(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return super.send(msg, selector, arg, timeout);
    }

}
