/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordConfigDto;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordStartEvent;

public final class RecordContextHolder {
    private static volatile boolean recording = false;
    private static volatile RecordContext recordContext;

    private RecordContextHolder() {
    }

    public static boolean isRecording() {
        return recording && recordContext != null;
    }

    public static synchronized void start(RecordConfigDto recordConfig) {
        if (RecordContextHolder.isRecording()) {
            throw new FlowReplayException("\u5f55\u5236\u64cd\u4f5c\u5df2\u7ecf\u5f00\u59cb_\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        recording = true;
        recordContext = new RecordContext(recordConfig);
        FlowReplayFileComponent.initDir();
        recordContext.start();
        MainApplicationContextHolder.getApplicationContext().publishEvent((Object)new RecordStartEvent());
    }

    public static void normalEnd() {
        RecordContextHolder.end(true, null);
    }

    public static void abnormalEnd(String message) {
        RecordContextHolder.end(false, message);
    }

    private static synchronized void end(boolean normal, String message) {
        if (!RecordContextHolder.isRecording()) {
            throw new FlowReplayException("\u5f55\u5236\u64cd\u4f5c\u5df2\u7ecf\u7ed3\u675f_\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        recording = false;
        recordContext.end();
        recordContext.recordFinished();
        MainApplicationContextHolder.getApplicationContext().publishEvent((Object)new RecordEndEvent(normal, message));
    }

    public static RecordContext getRecordContext() {
        return recordContext;
    }
}

