/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayClockMockSupport;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayConfigDto;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;

public class ReplayContextHolder {
    private static volatile boolean replaying = false;
    private static volatile ReplayContext replayContext;

    private ReplayContextHolder() {
    }

    public static boolean isReplaying() {
        return replaying && replayContext != null;
    }

    public static void start(ReplayConfigDto replayConfig) {
        if (replaying) {
            throw new FlowReplayException("\u56de\u5f52\u64cd\u4f5c\u5df2\u7ecf\u5f00\u59cb_\u8bf7\u52ff\u91cd\u590d\u5f00\u59cb");
        }
        replaying = true;
        replayContext = new ReplayContext(replayConfig);
        replayContext.start();
        ReplayClockMockSupport.setOffsetMillis(replayConfig.getStartTime() - replayContext.getStartTime());
        MainApplicationContextHolder.getApplicationContext().publishEvent((Object)new ReplayStartEvent());
    }

    public static void end() {
        if (!replaying) {
            throw new FlowReplayException("\u56de\u5f52\u64cd\u4f5c\u5df2\u7ecf\u7ed3\u675f_\u8bf7\u52ff\u91cd\u590d\u7ed3\u675f");
        }
        replaying = false;
        ReplayClockMockSupport.setOffsetMillis(0L);
        replayContext.end();
        MainApplicationContextHolder.getApplicationContext().publishEvent((Object)new ReplayEndEvent());
    }

    public static void forceEnd() {
        replayContext.tracesLoadFinish();
        replayContext.replayersDone();
        ReplayContextHolder.end();
    }

    public static ReplayContext getReplayContext() {
        return replayContext;
    }
}

