/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayTraceContext
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ReplayTraceContext.class);
    private static final long serialVersionUID = 2716578641071393051L;
    private String traceId;
    private FlowReplaySpan mainSpan;
    private LinkedList<FlowReplaySpan> subSpans;
    private boolean errorMarked;
    private FlowReplayErrorMsgTypeEnum errorMsgType;
    private String errorMsgDetail;

    public static void create(FlowReplayTrace trace) {
        ReplayTraceContext c = new ReplayTraceContext();
        c.traceId = trace.getTraceId();
        c.mainSpan = trace.getMainSpan();
        c.subSpans = new LinkedList<FlowReplaySpan>(trace.getSubSpans());
        c.errorMarked = false;
        c.errorMsgType = null;
        c.errorMsgDetail = null;
        TransmittableThreadLocalHolder.threadLocal2ReplayTraceContext.set((Object)c);
        ReplayTraceContext.traceLog(c);
    }

    private static void traceLog(ReplayTraceContext c) {
        if (log.isDebugEnabled()) {
            ArrayList<String> subSpanTypes = new ArrayList<String>();
            for (FlowReplaySpan span : c.subSpans) {
                subSpanTypes.add(span.getSpanType().toString());
            }
            log.debug("Replay_TraceId_{}_MainSpanType_{}_SubSpanTypes_{}", new Object[]{c.traceId, c.mainSpan.getSpanType(), Joiner.on((String)"|").join(subSpanTypes)});
        }
    }

    private static void markError(FlowReplayErrorMsgTypeEnum errorMsgType, String expert, String actual, String exceptionMsg) {
        ReplayTraceContext c = (ReplayTraceContext)TransmittableThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null || c.errorMarked) {
            return;
        }
        c.errorMarked = true;
        c.errorMsgType = errorMsgType;
        if (StringUtils.isNotBlank((CharSequence)exceptionMsg)) {
            c.errorMsgDetail = exceptionMsg;
        } else if (StringUtils.isNotBlank((CharSequence)expert) || StringUtils.isNotBlank((CharSequence)actual)) {
            c.errorMsgDetail = String.format("\u671f\u671b: %s, \u5b9e\u9645: %s", expert, actual);
        }
    }

    public static void markError(FlowReplayErrorMsgTypeEnum errorMsgType) {
        ReplayTraceContext.markError(errorMsgType, null, null, null);
    }

    public static void markError(FlowReplayErrorMsgTypeEnum errorMsgType, String expert, String actual) {
        ReplayTraceContext.markError(errorMsgType, expert, actual, null);
    }

    public static void markError(FlowReplayErrorMsgTypeEnum errorMsgType, String exceptionMsg) {
        ReplayTraceContext.markError(errorMsgType, null, null, exceptionMsg);
    }

    public static FlowReplaySpan pollSubSpan() {
        ReplayTraceContext c = (ReplayTraceContext)TransmittableThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null || c.subSpans == null) {
            return null;
        }
        return c.subSpans.poll();
    }

    public static ReplayTraceContext getAndRemove() {
        ReplayTraceContext c = (ReplayTraceContext)TransmittableThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null) {
            return null;
        }
        TransmittableThreadLocalHolder.threadLocal2ReplayTraceContext.remove();
        return c;
    }

    public static ReplayTraceContext get() {
        ReplayTraceContext c = (ReplayTraceContext)TransmittableThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null) {
            return null;
        }
        return c;
    }

    public static String getContextTraceId() {
        ReplayTraceContext c = (ReplayTraceContext)TransmittableThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        if (c == null) {
            return null;
        }
        return c.traceId;
    }

    public static void remove() {
        TransmittableThreadLocalHolder.threadLocal2ReplayTraceContext.remove();
    }

    public static boolean isReplaying() {
        ReplayTraceContext c = (ReplayTraceContext)TransmittableThreadLocalHolder.threadLocal2ReplayTraceContext.get();
        return c != null;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public FlowReplaySpan getMainSpan() {
        return this.mainSpan;
    }

    public LinkedList<FlowReplaySpan> getSubSpans() {
        return this.subSpans;
    }

    public boolean isErrorMarked() {
        return this.errorMarked;
    }

    public FlowReplayErrorMsgTypeEnum getErrorMsgType() {
        return this.errorMsgType;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getErrorMsgDetail() {
        return this.errorMsgDetail;
    }

    private static class TransmittableThreadLocalHolder {
        private static final TransmittableThreadLocal<ReplayTraceContext> threadLocal2ReplayTraceContext = new TransmittableThreadLocal();

        private TransmittableThreadLocalHolder() {
        }
    }
}

