/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.Replayer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ReplayTraceReplayer {
    private static final Logger log = LoggerFactory.getLogger(ReplayTraceReplayer.class);
    private static final int REPLAYER_POOL_SIZE = 10;
    @Resource
    private Replayer replayer;
    private ExecutorService es = Executors.newFixedThreadPool(10);

    @EventListener(value={ReplayStartEvent.class})
    public void replayStartEventListener(ReplayStartEvent event) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ReplayContext context = ReplayContextHolder.getReplayContext();
                if (context == null) {
                    return;
                }
                try {
                    ArrayList futures = new ArrayList(10);
                    for (int i = 0; i < 10; ++i) {
                        futures.add(ReplayTraceReplayer.this.es.submit(new ReplayerThread(context)));
                    }
                    for (Future future : futures) {
                        try {
                            log.debug("\u5f15\u6d41\u56de\u5f52_\u5f00\u59cb\u7b49\u5f85\u56de\u653e\u7ed3\u679c_reportId_{}", (Object)context.getReportId());
                            future.get();
                        }
                        catch (Exception e) {
                            log.error("\u5f15\u6d41\u56de\u5f52_ReplayerThread_Future_get_error", (Throwable)e);
                        }
                    }
                }
                finally {
                    context.replayersDone();
                }
            }
        }, "DBThread-Replay-Replayer").start();
    }

    private class ReplayerThread
    implements Runnable {
        private ReplayContext context;

        public ReplayerThread(ReplayContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.replay();
            }
            catch (Exception e) {
                log.error("\u5f15\u6d41\u56de\u5f52_\u56de\u653e\u5668\u7ebf\u7a0b\u5f02\u5e38_reportId_{}", (Object)this.context.getReportId(), (Object)e);
                ReplayContextHolder.forceEnd();
            }
        }

        private void replay() throws InterruptedException {
            while (!this.context.isTracesLoadFinished() || !this.context.isTraceQueueEmpty()) {
                FlowReplayTrace trace = this.context.pollTrace();
                if (trace == null) continue;
                try {
                    ReplayTraceResult traceResult = ReplayTraceReplayer.this.replayer.replay(trace);
                    this.context.offerResult(traceResult);
                }
                catch (Exception e) {
                    log.error("\u5f15\u6d41\u56de\u5f52_\u5355\u4e2a\u7528\u4f8b\u56de\u653e\u5f02\u5e38_reportId_{}_traceId_{}", new Object[]{this.context.getReportId(), trace.getTraceId(), e});
                }
            }
        }
    }
}

