/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayConfigDto;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class ReplayMvcEndpoint
extends AbstractNamedMvcEndpoint {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private FlowReplayFileComponent flowReplayFileComponent;

    public ReplayMvcEndpoint() {
        super("flow/replay", "/flow/replay", true);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public String invoke(@RequestBody ReplayConfigDto replayConfig) throws IOException {
        JsonResult<Object> result;
        try {
            if (!FlowReplayUtils.isReplayEnv()) {
                throw new FlowReplayException("\u5f53\u524d\u670d\u52a1\u975e\u56de\u653e\u4e13\u7528\u670d\u52a1\uff0c\u65e0\u6cd5\u8fdb\u884c\u56de\u653e\u76f8\u5173\u64cd\u4f5c");
            }
            if (!FlowReplayUtils.isReportIdValid(replayConfig.getReportId())) {
                throw new FlowReplayException("\u56de\u653e\u62a5\u544aID\u4e0d\u5408\u6cd5");
            }
            ReplayContextHolder.start(replayConfig);
            result = JsonResult.successResult("ok");
        }
        catch (Exception e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }
}

