package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.KryoSerializer;

import java.lang.reflect.Method;

/**
 * feignClient 类型的 Span
 * Created by guoyanfei .
 * 2019-01-24 .
 */
public class FeignClientFlowReplaySpan extends FlowReplaySpan {

    private static final long serialVersionUID = 6228393678957825891L;

    /**
     * 接口名称
     */
    private String apiName;

    /**
     * 参数类型数组
     */
    private String[] parameterTypes;

    /**
     * 参数值数组
     */
    private byte[] parameterValues;

    /**
     * 返回值类型
     */
    private String returnType;

    /**
     * 返回值
     */
    private byte[] returnValue;

    /**
     * 类名
     */
    private String typeName;

    /**
     * 调用的接口方法
     */
    private String methodName;

    /**
     * 接口所在类，全路径，例如：cn.com.duiba.message.service.remoteservice.RemoteSmsService
     */
    private String typeFullPath;

    @Override
    public SpanType getSpanType() {
        return SpanType.FEIGN_CLIENT;
    }

    public static FeignClientFlowReplaySpan createSpan(Method method, Object[] args, Object ret) {
        Class[] parameterTypeClasses = method.getParameterTypes();
        String[] parameterTypes = null;
        if (parameterTypeClasses.length > 0) {
            parameterTypes = new String[parameterTypeClasses.length];
            for (int i = 0; i < parameterTypeClasses.length; i++) {
                parameterTypes[i] = parameterTypeClasses[i].getName();
            }
        }
        Class returnTypeClass = method.getReturnType();
        FeignClientFlowReplaySpan span = new FeignClientFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.apiName = FlowReplayUtils.parseApiNameByMethod(method);
        span.parameterTypes = parameterTypes;
        span.parameterValues = KryoSerializer.serialize(args);
        span.returnType = returnTypeClass != null ? returnTypeClass.getName() : null;
        span.typeFullPath = method.getDeclaringClass().getName();
        span.methodName = method.getName();
        span.typeName = method.getDeclaringClass().getSimpleName();
        span.returnValue = KryoSerializer.serialize(ret);
        return span;
    }

    public String getApiName() {
        return apiName;
    }

    public String[] getParameterTypes() {
        return parameterTypes;
    }

    public Object[] getParameterValues() {
        return (Object[]) KryoSerializer.deserialize(parameterValues);
    }

    public String getReturnType() {
        return returnType;
    }

    public Object getReturnValue() {
        return KryoSerializer.deserialize(returnValue);
    }

    public String getTypeName() {
        return typeName;
    }

    public String getMethodName() {
        return methodName;
    }

    public String getTypeFullPath() {
        return typeFullPath;
    }
}
