package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * 提前初始化 ReplayClockMockSupport 类，启动完成后初始化，使用 ReplayClockMockSupport.setOffsetMillis 会报错
 * Created by guoyanfei .
 * 2019-05-06 .
 */
@Slf4j
public class ReplayClockMockInitRunListener implements SpringApplicationRunListener {

    private SpringApplication application;

    /**
     * 必须有这个构造函数，否则spring无法初始化该类
     * @param application
     * @param args
     */
    public ReplayClockMockInitRunListener(SpringApplication application, String[] args) {
        this.application = application;
    }

    @Override
    public void starting() {
        if (FlowReplayUtils.isReplayEnv()) {
            try {
                Class.forName("cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayClockMockSupport");
            } catch (ClassNotFoundException e) {
                log.error("Init ReplayClockMockSupport error", e);
            }
        }
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        //do nothing
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {
        //do nothing
    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {
        //do nothing
    }

    @Override
    public void finished(ConfigurableApplicationContext context, Throwable exception) {
        //do nothing
    }
}
