package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * 实际操作的回放器
 * Created by guoyanfei .
 * 2019-02-26 .
 */
@Slf4j
public class ConcreateReplayer implements Replayer {

    @Resource
    private RemoteServiceReplayer remoteServiceReplayer;

    @Resource
    private SpringMvcReplayer springMvcReplayer;

    @Override
    public ReplayTraceResult replay(FlowReplayTrace trace) {
        FlowReplaySpan mainSpan = trace.getMainSpan();
        if (mainSpan == null) {
            throw new FlowReplayException("无效的trace_traceId_" + trace.getTraceId());
        }
        switch (mainSpan.getSpanType()) {
            case REMOTE_SERVICE:
                return remoteServiceReplayer.replay(trace);
            case SPRING_MVC:
                return springMvcReplayer.replay(trace);
            default:
                throw new FlowReplayException("暂不支持的回放类型_traceId_" + trace.getTraceId());
        }
    }
}
